/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultExceptionContext
implements ExceptionContext,
Serializable {
    private static final long serialVersionUID = 293747957535772807L;
    private Map<String, Object> contextValueMap = new LinkedHashMap<String, Object>();

    DefaultExceptionContext() {
    }

    @Override
    public ExceptionContext addValue(String label, Object value) {
        String key = label;
        int i = 0;
        while (this.contextValueMap.containsKey(key)) {
            Object information = this.contextValueMap.get(key);
            if (value == null && information == null || value != null && value.equals(information)) {
                return this;
            }
            key = label + "[" + ++i + "]";
        }
        this.contextValueMap.put(key, value);
        return this;
    }

    @Override
    public ExceptionContext replaceValue(String label, Object value) {
        this.contextValueMap.put(label, value);
        return this;
    }

    @Override
    public Object getValue(String label) {
        return this.contextValueMap.get(label);
    }

    @Override
    public Set<String> getLabelSet() {
        return this.contextValueMap.keySet();
    }

    @Override
    public String getFormattedExceptionMessage(String baseMessage) {
        StringBuilder buffer = new StringBuilder(256);
        if (baseMessage != null) {
            buffer.append(baseMessage);
        }
        if (this.contextValueMap.size() > 0) {
            if ((long)buffer.length() > 0L) {
                buffer.append(SystemUtils.LINE_SEPARATOR);
            }
            buffer.append("Exception Context:");
            buffer.append(SystemUtils.LINE_SEPARATOR);
            buffer.append("\t");
            for (String label : this.contextValueMap.keySet()) {
                buffer.append("[");
                buffer.append(label);
                buffer.append("=");
                Object value = this.contextValueMap.get(label);
                if (value == null) {
                    buffer.append("null");
                } else {
                    String valueStr;
                    try {
                        valueStr = value.toString();
                    }
                    catch (Exception e) {
                        valueStr = "Exception thrown on toString(): " + ExceptionUtils.getStackTrace(e);
                    }
                    buffer.append(valueStr);
                }
                buffer.append("]");
                buffer.append(SystemUtils.LINE_SEPARATOR);
                buffer.append("\t");
            }
            buffer.append("---------------------------------");
        }
        return buffer.toString();
    }
}

