/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.facile.mode.ExternalizedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.MaximizedMode;
import bibliothek.gui.dock.facile.mode.MaximizedModeSetting;
import bibliothek.gui.dock.facile.mode.MinimizedMode;
import bibliothek.gui.dock.facile.mode.NormalMode;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLocationModeSettings<B>
extends ModeSettings<Location, B> {
    private Map<String, B> lastMaximizedLocation;
    private Map<String, String> lastMaximizedMode;
    private static final String MINIMIZED = "mini";
    private static final String MAXIMIZED = "maxi";
    private static final String NORMALIZED = "normal";
    private static final String EXTERNALIZED = "extern";

    public CLocationModeSettings(ModeSettingsConverter<Location, B> converter) {
        super(converter);
    }

    public void rescue(CMaximizedMode maximizedMode) {
        if (this.lastMaximizedLocation != null) {
            MaximizedModeSetting setting = new MaximizedModeSetting();
            HashMap<String, Path> translatedLastMaximizedMode = new HashMap<String, Path>();
            for (Map.Entry<String, String> pair : this.lastMaximizedMode.entrySet()) {
                String mode = pair.getValue();
                Path result = this.resuceMode(mode);
                if (result == null) continue;
                translatedLastMaximizedMode.put(pair.getKey(), result);
            }
            HashMap<String, Location> translatedLastMaximizedLocation = new HashMap<String, Location>();
            for (Map.Entry<String, B> pair : this.lastMaximizedLocation.entrySet()) {
                Location location = (Location)this.getConverter().convertToWorld(pair.getValue());
                translatedLastMaximizedLocation.put(pair.getKey(), location);
            }
            translatedLastMaximizedLocation.keySet().retainAll(translatedLastMaximizedMode.keySet());
            translatedLastMaximizedMode.keySet().retainAll(translatedLastMaximizedLocation.keySet());
            setting.setLastMaximizedLocation(translatedLastMaximizedLocation);
            setting.setLastMaximizedMode(translatedLastMaximizedMode);
            maximizedMode.readSetting(setting);
        }
    }

    @Override
    protected Path resuceMode(String mode) {
        if (MINIMIZED.equals(mode)) {
            return MinimizedMode.IDENTIFIER;
        }
        if (NORMALIZED.equals(mode)) {
            return NormalMode.IDENTIFIER;
        }
        if (EXTERNALIZED.equals(mode)) {
            return ExternalizedMode.IDENTIFIER;
        }
        if (MAXIMIZED.equals(mode)) {
            return MaximizedMode.IDENTIFIER;
        }
        return null;
    }

    @Override
    protected void rescueSettings(DataInputStream in, Version version) throws IOException {
        if (version.compareTo(Version.VERSION_1_0_7) < 0) {
            if (in.readBoolean()) {
                in.readUTF();
            }
            if (in.readBoolean()) {
                this.getConverter().readProperty(in);
            }
        } else if (version.compareTo(Version.VERSION_1_0_7) == 0) {
            String value;
            String key;
            int i;
            this.lastMaximizedLocation = new HashMap<String, B>();
            this.lastMaximizedMode = new HashMap<String, String>();
            int count = in.readInt();
            for (i = 0; i < count; ++i) {
                key = in.readUTF();
                value = in.readUTF();
                this.lastMaximizedMode.put(key, value);
            }
            count = in.readInt();
            for (i = 0; i < count; ++i) {
                key = in.readUTF();
                value = this.getConverter().readProperty(in);
                this.lastMaximizedLocation.put(key, value);
            }
        }
    }

    @Override
    protected void rescueSettings(XElement element) {
        XElement states = element.getElement("states");
        if (states != null) {
            this.lastMaximizedLocation = new HashMap<String, B>();
            this.lastMaximizedMode = new HashMap<String, String>();
            XElement xmaximized = element.getElement("maximized");
            if (xmaximized != null) {
                for (XElement xitem : xmaximized.getElements("item")) {
                    XElement xlocation;
                    String key = xitem.getString("id");
                    XElement xmode = xitem.getElement("mode");
                    if (xmode != null) {
                        this.lastMaximizedMode.put(key, xmode.getString());
                    }
                    if ((xlocation = xitem.getElement("location")) == null) continue;
                    XElement xcopy = xlocation.copy();
                    xcopy.addElement("mode").setString(MaximizedMode.IDENTIFIER.toString());
                    this.lastMaximizedLocation.put(key, this.getConverter().readPropertyXML(xcopy));
                }
            }
        }
    }
}

