/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.dom.attribute.text.TextDisplayAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextFixedAttribute;

public class TextFileNameElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.TEXT, "file-name");

    public TextFileNameElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getTextDisplayAttribute() {
        TextDisplayAttribute attr = (TextDisplayAttribute)this.getOdfAttribute(OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "display");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextDisplayAttribute(String textDisplayValue) {
        TextDisplayAttribute attr = new TextDisplayAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textDisplayValue);
    }

    public Boolean getTextFixedAttribute() {
        TextFixedAttribute attr = (TextFixedAttribute)this.getOdfAttribute(OdfNamespace.newNamespace(OdfNamespaceNames.TEXT), "fixed");
        if (attr != null) {
            return attr.booleanValue();
        }
        return null;
    }

    public void setTextFixedAttribute(Boolean textFixedValue) {
        TextFixedAttribute attr = new TextFixedAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(textFixedValue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextDisplayAttributeValue {
        FULL(TextDisplayAttribute.Value.FULL.toString()),
        NAME(TextDisplayAttribute.Value.NAME.toString()),
        NAME_AND_EXTENSION(TextDisplayAttribute.Value.NAME_AND_EXTENSION.toString()),
        PATH(TextDisplayAttribute.Value.PATH.toString());

        private String mValue;

        private TextDisplayAttributeValue(String value) {
            this.mValue = value;
        }

        public String toString() {
            return this.mValue;
        }

        public static TextDisplayAttributeValue enumValueOf(String value) {
            for (TextDisplayAttributeValue aIter : TextDisplayAttributeValue.values()) {
                if (!value.equals(aIter.toString())) continue;
                return aIter;
            }
            return null;
        }
    }
}

