/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.split.VisibleSplitNode;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.RootPlaceholderStrategy;
import bibliothek.util.Path;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Leaf
extends VisibleSplitNode {
    private StationChildHandle handle;

    public Leaf(SplitDockAccess access) {
        super(access, -1L);
    }

    public Leaf(SplitDockAccess access, long id) {
        super(access, id);
    }

    public void setHandle(StationChildHandle handle) {
        this.handle = handle;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.handle == null) {
            return new Dimension(0, 0);
        }
        DockableDisplayer displayer = this.handle.getDisplayer();
        if (displayer == null) {
            return new Dimension(0, 0);
        }
        return displayer.getComponent().getMinimumSize();
    }

    @Override
    public int getChildLocation(SplitNode child) {
        return -1;
    }

    @Override
    public void setChild(SplitNode child, int location) {
        throw new IllegalStateException("can't add children to a leaf");
    }

    @Override
    public int getMaxChildrenCount() {
        return 0;
    }

    @Override
    public SplitNode getChild(int location) {
        return null;
    }

    public void setDockable(Dockable dockable, DockHierarchyLock.Token token) {
        this.setDockable(dockable, token, true, false);
    }

    public void setDockable(Dockable dockable, DockHierarchyLock.Token token, boolean updatePlaceholders, boolean storePlaceholderMap) {
        if (this.handle != null) {
            if (updatePlaceholders) {
                this.getAccess().getPlaceholderSet().set((SplitNode)this, this.handle.getDockable(), new SplitNode[0]);
            }
            if (storePlaceholderMap) {
                DockStation station = this.handle.getDockable().asDockStation();
                if (station == null) {
                    throw new IllegalStateException("no station as child but storePlaceholderMap is set");
                }
                this.setPlaceholderMap(station.getPlaceholders());
            }
            this.getAccess().removeHandle(this.handle, token);
            this.handle = null;
        }
        if (dockable != null) {
            this.handle = this.getAccess().newHandle(dockable);
            if (updatePlaceholders) {
                this.getAccess().getPlaceholderSet().set(null, dockable, new SplitNode[0]);
            }
            this.getAccess().addHandle(this.handle, token);
        }
        this.treeChanged();
    }

    public Dockable getDockable() {
        return this.handle == null ? null : this.handle.getDockable();
    }

    public DockableDisplayer getDisplayer() {
        return this.handle == null ? null : this.handle.getDisplayer();
    }

    public StationChildHandle getDockableHandle() {
        return this.handle;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public SplitNode getVisible() {
        return this;
    }

    @Override
    public boolean isOfUse() {
        if (!this.getAccess().isTreeAutoCleanupEnabled()) {
            return true;
        }
        return this.handle != null || this.hasPlaceholders();
    }

    public void placehold(boolean keepCurrent) {
        Dockable dockable = this.getDockable();
        if (dockable != null) {
            DockStation station;
            SplitDockAccess access = this.getAccess();
            RootPlaceholderStrategy strategy = access.getOwner().getPlaceholderStrategy();
            if (strategy != null) {
                this.updatePlaceholders(dockable, keepCurrent, strategy);
            }
            if ((station = dockable.asDockStation()) != null && keepCurrent) {
                this.setPlaceholderMap(station.getPlaceholders());
            }
        }
        if (this.hasPlaceholders()) {
            Placeholder placeholder = this.createPlaceholder(this.getId());
            placeholder.setPlaceholders(this.getPlaceholders());
            this.movePlaceholderMap(placeholder);
            this.replace(placeholder);
        } else {
            this.delete(true);
        }
    }

    private void updatePlaceholders(Dockable dockable, boolean keep, PlaceholderStrategy strategy) {
        DockStation station;
        Path placeholder = strategy.getPlaceholderFor(dockable);
        if (placeholder != null) {
            if (!keep) {
                this.getAccess().getPlaceholderSet().set(null, placeholder, new SplitNode[0]);
            } else {
                this.getAccess().getPlaceholderSet().set((SplitNode)this, placeholder, new SplitNode[0]);
            }
        }
        if ((station = dockable.asDockStation()) != null) {
            int n = station.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.updatePlaceholders(station.getDockable(i), keep, strategy);
            }
        }
    }

    @Override
    public void updateBounds(double x, double y, double width, double height, double factorW, double factorH, boolean components) {
        super.updateBounds(x, y, width, height, factorW, factorH, components);
        DockableDisplayer displayer = this.getDisplayer();
        StationChildHandle fullscreen = this.getAccess().getFullScreenDockable();
        if (components && displayer != null && (fullscreen == null || displayer != fullscreen.getDisplayer())) {
            displayer.getComponent().setBounds(this.getBounds());
        }
    }

    @Override
    public PutInfo getPut(int x, int y, double factorW, double factorH, Dockable drop) {
        DockableDisplayer displayer = this.getDisplayer();
        if (displayer == null) {
            return null;
        }
        Rectangle bounds = this.getBounds();
        PutInfo result = null;
        if (displayer.getTitle() != null) {
            int width;
            int height;
            if (displayer.getTitleLocation() == DockableDisplayer.Location.TOP) {
                height = displayer.getTitle().getComponent().getHeight();
                bounds.y += height;
                bounds.height -= height;
                if (y <= bounds.y) {
                    result = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TITLE, drop));
                }
            } else if (displayer.getTitleLocation() == DockableDisplayer.Location.BOTTOM) {
                height = displayer.getTitle().getComponent().getHeight();
                bounds.height -= height;
                if (y >= bounds.y + bounds.height) {
                    result = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TITLE, drop));
                }
            } else if (displayer.getTitleLocation() == DockableDisplayer.Location.LEFT) {
                width = displayer.getTitle().getComponent().getWidth();
                bounds.x += width;
                bounds.width -= width;
                if (x <= bounds.x) {
                    result = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TITLE, drop));
                }
            } else if (displayer.getTitleLocation() == DockableDisplayer.Location.RIGHT) {
                width = displayer.getTitle().getComponent().getWidth();
                bounds.width -= width;
                if (x >= bounds.x + bounds.width) {
                    result = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TITLE, drop));
                }
            }
        }
        if (result != null) {
            return result;
        }
        float sideSnapSize = this.getAccess().getOwner().getSideSnapSize();
        if ((float)x > (float)bounds.x + sideSnapSize * (float)bounds.width && (float)x < (float)(bounds.x + bounds.width) - sideSnapSize * (float)bounds.width && (float)y > (float)bounds.y + sideSnapSize * (float)bounds.height && (float)y < (float)(bounds.y + bounds.height) - sideSnapSize * (float)bounds.height) {
            result = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.CENTER, drop));
        }
        if (result != null) {
            return result;
        }
        result = Leaf.above(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, x, y) ? (Leaf.above(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y, x, y) ? this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TOP, drop)) : this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.RIGHT, drop))) : (Leaf.above(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y, x, y) ? this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.LEFT, drop)) : this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.BOTTOM, drop)));
        if (result != null) {
            return result;
        }
        return this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.CENTER, drop));
    }

    @Override
    public boolean isInOverrideZone(int x, int y, double factorW, double factorH) {
        float sideSnapSize = this.getAccess().getOwner().getSideSnapSize();
        Rectangle bounds = this.getBounds();
        return !((float)x > (float)bounds.x + sideSnapSize * (float)bounds.width) || !((float)x < (float)(bounds.x + bounds.width) - sideSnapSize * (float)bounds.width) || !((float)y > (float)bounds.y + sideSnapSize * (float)bounds.height) || !((float)y < (float)(bounds.y + bounds.height) - sideSnapSize * (float)bounds.height);
    }

    @Override
    public void evolve(SplitDockTree.Key key, boolean checkValidity, Map<Leaf, Dockable> linksToSet) {
        this.setPlaceholders(key.getTree().getPlaceholders(key));
        this.setPlaceholderMap(key.getTree().getPlaceholderMap(key));
    }

    @Override
    public boolean insert(SplitDockPlaceholderProperty property, Dockable dockable) {
        Path placeholder = property.getPlaceholder();
        if (this.hasPlaceholder(placeholder)) {
            boolean done;
            DockStation station = this.getDockable().asDockStation();
            DockableProperty stationLocation = property.getSuccessor();
            if (station != null && stationLocation != null && dockable.accept(station) && station.accept(dockable)) {
                boolean done2;
                MultiDockAcceptance acceptance;
                DockController controller = this.getAccess().getOwner().getController();
                MultiDockAcceptance multiDockAcceptance = acceptance = controller == null ? null : controller.getAcceptance();
                if ((acceptance == null || acceptance.accept(station, dockable)) && (done2 = station.drop(dockable, stationLocation))) {
                    this.getAccess().getPlaceholderSet().set(null, placeholder, this);
                    return true;
                }
            }
            if (done = this.getAccess().drop(dockable, property.toSplitLocation(this), this)) {
                this.removePlaceholder(placeholder);
            }
            return done;
        }
        return false;
    }

    @Override
    public boolean insert(SplitDockPathProperty property, int depth, Dockable dockable) {
        if (depth < property.size()) {
            Node split;
            Leaf leaf;
            SplitDockPathProperty.Node node = property.getNode(depth);
            SplitDockStation.Orientation orientation = node.getLocation() == SplitDockPathProperty.Location.LEFT || node.getLocation() == SplitDockPathProperty.Location.RIGHT ? SplitDockStation.Orientation.HORIZONTAL : SplitDockStation.Orientation.VERTICAL;
            boolean reverse = node.getLocation() == SplitDockPathProperty.Location.RIGHT || node.getLocation() == SplitDockPathProperty.Location.BOTTOM;
            SplitDockPathProperty.Node lastNode = property.getLastNode();
            long newNodeId = -1L;
            if (lastNode != null) {
                newNodeId = lastNode.getId();
            }
            if ((leaf = this.create(dockable, property.getLeafId())) == null) {
                return false;
            }
            SplitNode parent = this.getParent();
            int location = parent.getChildLocation(this);
            if (reverse) {
                split = new Node(this.getAccess(), this, leaf, orientation, newNodeId);
                split.setDivider(1.0 - node.getSize());
            } else {
                split = new Node(this.getAccess(), leaf, this, orientation, newNodeId);
                split.setDivider(node.getSize());
            }
            parent.setChild(split, location);
            leaf.setDockable(dockable, null);
            return true;
        }
        DockStation station = this.getDockable().asDockStation();
        DockableProperty stationLocation = property.getSuccessor();
        if (station != null && stationLocation != null && dockable.accept(station) && station.accept(dockable)) {
            boolean done;
            MultiDockAcceptance acceptance;
            DockController controller = this.getAccess().getOwner().getController();
            MultiDockAcceptance multiDockAcceptance = acceptance = controller == null ? null : controller.getAcceptance();
            if ((acceptance == null || acceptance.accept(station, dockable)) && (done = station.drop(dockable, stationLocation))) {
                return true;
            }
        }
        return this.getAccess().drop(dockable, property.toLocation(this), this);
    }

    @Override
    public <N> N submit(SplitTreeFactory<N> factory) {
        DockStation station;
        Dockable dockable;
        PlaceholderMap map = this.getPlaceholderMap();
        if (map == null && (dockable = this.getDockable()) != null && (station = dockable.asDockStation()) != null) {
            map = station.getPlaceholders();
        }
        return factory.leaf(this.getDockable(), this.getId(), this.getPlaceholders(), map);
    }

    @Override
    public Leaf getLeaf(Dockable dockable) {
        Dockable mine = this.getDockable();
        if (mine != null && dockable == this.getDockable()) {
            return this;
        }
        return null;
    }

    @Override
    public Node getDividerNode(int x, int y) {
        return null;
    }

    @Override
    public void visit(SplitNodeVisitor visitor) {
        visitor.handleLeaf(this);
    }

    @Override
    public void toString(int tabs, StringBuilder out) {
        Dockable dockable = this.getDockable();
        out.append("Leaf[ ");
        if (dockable != null) {
            out.append(dockable.getTitleText());
            out.append(", ");
        }
        out.append("placeholders={");
        Path[] placeholders = this.getPlaceholders();
        if (placeholders != null) {
            for (int i = 0; i < placeholders.length; ++i) {
                if (i > 0) {
                    out.append(", ");
                }
                out.append(placeholders[i].toString());
            }
        }
        out.append("}, ");
        out.append("id=");
        out.append(this.getId());
        out.append(" ]");
    }
}

