/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.TabContent;
import bibliothek.gui.dock.station.stack.tab.AbstractTabContentFilter;
import javax.swing.Icon;

public class DefaultTabContentFilter
extends AbstractTabContentFilter {
    private Behavior deselected;
    private Behavior selected;

    public DefaultTabContentFilter() {
        this(Behavior.ALL);
    }

    public DefaultTabContentFilter(Behavior behavior) {
        this(behavior, behavior);
    }

    public DefaultTabContentFilter(Behavior selected, Behavior deselected) {
        this.setSelected(selected);
        this.setDeselected(deselected);
    }

    public void setSelected(Behavior selected) {
        if (selected == null) {
            throw new IllegalArgumentException("selected must not be null");
        }
        if (this.selected != selected) {
            this.selected = selected;
            this.fireChanged();
        }
    }

    public Behavior getSelected() {
        return this.selected;
    }

    public void setDeselected(Behavior deselected) {
        if (deselected == null) {
            throw new IllegalArgumentException("deselected must not be null");
        }
        if (this.deselected != deselected) {
            this.deselected = deselected;
            this.fireChanged();
        }
    }

    public Behavior getDeselected() {
        return this.deselected;
    }

    public TabContent filter(TabContent content, StackDockStation station, Dockable dockable) {
        boolean selected = station.getFrontDockable() == dockable;
        return this.filter(content, selected ? this.selected : this.deselected);
    }

    public TabContent filter(TabContent content, StackDockComponent component, Dockable dockable) {
        int selection = component.getSelectedIndex();
        boolean selected = selection >= 0 && component.getDockableAt(selection) == dockable;
        return this.filter(content, selected ? this.selected : this.deselected);
    }

    protected void selected(StackDockStation station, Dockable dockable) {
        if (this.selected != this.deselected) {
            this.fireChanged(dockable);
        }
    }

    protected void deselected(StackDockStation station, Dockable dockable) {
        if (this.selected != this.deselected) {
            this.fireChanged(dockable);
        }
    }

    protected void selectionChanged(StackDockComponent component) {
        if (this.selected != this.deselected) {
            this.fireChanged(component);
        }
    }

    private TabContent filter(TabContent content, Behavior behavior) {
        Icon icon = content.getIcon();
        String title = content.getTitle();
        String tooltip = content.getTooltip();
        switch (behavior) {
            case ICON_ONLY: {
                title = null;
                break;
            }
            case ICON_OVER_TEXT: {
                if (icon == null) break;
                title = null;
                break;
            }
            case TEXT_ONLY: {
                icon = null;
                break;
            }
            case TEXT_OVER_ICON: {
                if (title == null) break;
                icon = null;
            }
        }
        return new TabContent(icon, title, tooltip);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Behavior {
        ALL,
        ICON_ONLY,
        TEXT_ONLY,
        ICON_OVER_TEXT,
        TEXT_OVER_ICON;

    }
}

