/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.search;

import java.util.Hashtable;
import java.util.Vector;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.incubator.search.InvalidNavigationException;
import org.odftoolkit.odfdom.incubator.search.TextSelection;

public abstract class Selection {
    private OdfElement mElement;
    private int mIndex;

    public OdfElement getElement() {
        return this.mElement;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public abstract void cut() throws InvalidNavigationException;

    public abstract void pasteAtFrontOf(Selection var1) throws InvalidNavigationException;

    public abstract void pasteAtEndOf(Selection var1) throws InvalidNavigationException;

    protected abstract void refreshAfterFrontalDelete(Selection var1);

    protected abstract void refreshAfterFrontalInsert(Selection var1);

    protected abstract void refresh(int var1);

    static class SelectionManager {
        private static Hashtable<OdfElement, Vector<Selection>> repository = new Hashtable();

        public static void registerItem(Selection item) {
            OdfElement element = item.getElement();
            if (repository.containsKey((Object)element)) {
                int i;
                Vector<Selection> selections = repository.get((Object)element);
                for (i = 0; i < selections.size(); ++i) {
                    if (selections.get(i).getIndex() <= item.getIndex()) continue;
                    selections.insertElementAt(item, i);
                    break;
                }
                if (i == selections.size()) {
                    selections.add(item);
                }
            } else {
                Vector<Selection> al = new Vector<Selection>();
                al.add(item);
                repository.put(element, al);
            }
        }

        public static synchronized void refreshAfterCut(Selection cutItem) {
            OdfElement element = cutItem.getElement();
            if (repository.containsKey((Object)element)) {
                Vector<Selection> selections = repository.get((Object)element);
                for (int i = 0; i < selections.size(); ++i) {
                    if (selections.get(i).getIndex() <= cutItem.getIndex()) continue;
                    selections.get(i).refreshAfterFrontalDelete(cutItem);
                }
            }
        }

        public static synchronized void refreshAfterPasteAtFrontOf(Selection item, Selection positionItem) {
            OdfElement element = positionItem.getElement();
            if (repository.containsKey((Object)element)) {
                Vector<Selection> selections = repository.get((Object)element);
                for (int i = 0; i < selections.size(); ++i) {
                    if (selections.get(i).getIndex() < positionItem.getIndex()) continue;
                    selections.get(i).refreshAfterFrontalInsert(item);
                }
            }
        }

        public static synchronized void refreshAfterPasteAtEndOf(Selection item, Selection positionItem) {
            OdfElement element = positionItem.getElement();
            int positionIndex = positionItem instanceof TextSelection ? positionItem.getIndex() + ((TextSelection)positionItem).getText().length() : positionItem.getIndex();
            if (repository.containsKey((Object)element)) {
                Vector<Selection> selections = repository.get((Object)element);
                for (int i = 0; i < selections.size(); ++i) {
                    if (selections.get(i).getIndex() < positionIndex) continue;
                    selections.get(i).refreshAfterFrontalInsert(item);
                }
            }
        }

        public static void unregisterItem(Selection item) {
            OdfElement element = item.getElement();
            if (repository.containsKey((Object)element)) {
                Vector<Selection> selections = repository.get((Object)element);
                selections.remove(item);
            }
        }

        public static synchronized void refresh(OdfElement containerElement, int offset, int positionIndex) {
            if (repository.containsKey((Object)containerElement)) {
                Vector<Selection> selections = repository.get((Object)containerElement);
                for (int i = 0; i < selections.size(); ++i) {
                    if (selections.get(i).getIndex() < positionIndex) continue;
                    selections.get(i).refresh(offset);
                }
            }
        }

        private SelectionManager() {
        }
    }
}

