/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.layout;

import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockLayoutComposition {
    private DockLayoutInfo layout;
    private List<DockLayout<?>> adjacent;
    private List<DockLayoutComposition> children;
    private boolean ignoreChildren;

    public DockLayoutComposition(DockLayoutInfo layout, List<DockLayout<?>> adjacent, List<DockLayoutComposition> children, boolean ignoreChildren) {
        if (children == null) {
            throw new IllegalArgumentException("children must not be null");
        }
        this.layout = layout;
        this.adjacent = adjacent;
        this.children = children;
        this.ignoreChildren = ignoreChildren;
    }

    public DockLayoutInfo getLayout() {
        return this.layout;
    }

    public List<DockLayout<?>> getAdjacent() {
        return this.adjacent;
    }

    public DockLayout<?> getAdjacent(String factoryId) {
        if (this.adjacent != null) {
            for (DockLayout<?> layout : this.adjacent) {
                if (!layout.getFactoryID().equals(factoryId)) continue;
                return layout;
            }
        }
        return null;
    }

    public List<DockLayoutComposition> getChildren() {
        return this.children;
    }

    public boolean isIgnoreChildren() {
        return this.ignoreChildren;
    }
}

