/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.screen.RetroScreenDockStationLayout;
import bibliothek.gui.dock.station.screen.ScreenDockPerspective;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.station.screen.ScreenDockStationLayout;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenDockStationFactory
implements DockFactory<ScreenDockStation, ScreenDockPerspective, ScreenDockStationLayout> {
    public static final String ID = "screen dock";
    private WindowProvider owner;

    public ScreenDockStationFactory(Window owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
        this.owner = new DirectWindowProvider(owner);
    }

    public ScreenDockStationFactory(WindowProvider owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
        this.owner = owner;
    }

    @Deprecated
    public Window getOwner() {
        return this.owner.searchWindow();
    }

    public WindowProvider getProvider() {
        return this.owner;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public void estimateLocations(ScreenDockStationLayout layout, final LocationEstimationMap children) {
        if (layout instanceof RetroScreenDockStationLayout) {
            RetroScreenDockStationLayout retro = (RetroScreenDockStationLayout)layout;
            int n = retro.size();
            for (int i = 0; i < n; ++i) {
                DockLayoutInfo info = children.getChild(retro.id(i));
                if (info == null) continue;
                ScreenDockProperty property = new ScreenDockProperty(retro.x(i), retro.y(i), retro.width(i), retro.height(i), null);
                info.setLocation(property);
            }
        } else {
            DockablePlaceholderList.simulatedRead(layout.getPlaceholders(), new PlaceholderListItemAdapter<Dockable, PlaceholderListItem<Dockable>>(){

                @Override
                public PlaceholderListItem<Dockable> convert(ConvertedPlaceholderListItem item) {
                    int id = item.getInt("id");
                    int x = item.getInt("x");
                    int y = item.getInt("y");
                    int width = item.getInt("width");
                    int height = item.getInt("height");
                    boolean fullscreen = item.getBoolean("fullscreen");
                    Path placeholder = null;
                    if (item.contains("placeholder")) {
                        placeholder = new Path(item.getString("placeholder"));
                    }
                    ScreenDockProperty property = new ScreenDockProperty(x, y, width, height, placeholder, fullscreen);
                    children.getChild(id).setLocation(property);
                    int n = children.getSubChildCount(id);
                    for (int i = 0; i < n; ++i) {
                        DockLayoutInfo info = children.getSubChild(id, i);
                        info.setLocation(new ScreenDockProperty(x, y, width, height, info.getPlaceholder(), fullscreen));
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public ScreenDockStationLayout getLayout(ScreenDockStation station, Map<Dockable, Integer> children) {
        return new ScreenDockStationLayout(station.getPlaceholders(children));
    }

    @Override
    public void setLayout(ScreenDockStation element, ScreenDockStationLayout layout, PlaceholderStrategy placeholders) {
    }

    @Override
    public void setLayout(ScreenDockStation station, ScreenDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        for (int i = station.getDockableCount() - 1; i >= 0; --i) {
            station.removeDockable(i);
        }
        if (layout instanceof RetroScreenDockStationLayout) {
            RetroScreenDockStationLayout retro = (RetroScreenDockStationLayout)layout;
            int n = retro.size();
            for (int i = 0; i < n; ++i) {
                Dockable dockable = children.get(retro.id(i));
                if (dockable == null) continue;
                Rectangle location = new Rectangle(retro.x(i), retro.y(i), retro.width(i), retro.height(i));
                station.addDockable(dockable, location, true);
            }
        } else {
            station.setPlaceholders(layout.getPlaceholders().filter(placeholders), children);
        }
    }

    @Override
    public ScreenDockStation layout(ScreenDockStationLayout layout, PlaceholderStrategy placeholders) {
        ScreenDockStation station = this.createStation();
        this.setLayout(station, layout, placeholders);
        return station;
    }

    @Override
    public ScreenDockStation layout(ScreenDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        ScreenDockStation station = this.createStation();
        this.setLayout(station, layout, children, placeholders);
        return station;
    }

    @Override
    public ScreenDockStationLayout getPerspectiveLayout(ScreenDockPerspective element, Map<PerspectiveDockable, Integer> children) {
        return new ScreenDockStationLayout(element.toMap(children));
    }

    @Override
    public ScreenDockPerspective layoutPerspective(ScreenDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        ScreenDockPerspective result = new ScreenDockPerspective();
        this.layoutPerspective(result, layout, children);
        return result;
    }

    @Override
    public void layoutPerspective(ScreenDockPerspective perspective, ScreenDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        perspective.read(layout.getPlaceholders(), children);
    }

    @Override
    public void write(ScreenDockStationLayout layout, DataOutputStream out) throws IOException {
        if (layout instanceof RetroScreenDockStationLayout) {
            RetroScreenDockStationLayout retro = (RetroScreenDockStationLayout)layout;
            Version.write(out, Version.VERSION_1_0_4);
            out.writeInt(retro.size());
            int n = retro.size();
            for (int i = 0; i < n; ++i) {
                out.writeInt(retro.id(i));
                out.writeInt(retro.x(i));
                out.writeInt(retro.y(i));
                out.writeInt(retro.width(i));
                out.writeInt(retro.height(i));
            }
        } else {
            PlaceholderMap map = layout.getPlaceholders();
            Version.write(out, Version.VERSION_1_0_8);
            map.write(out);
        }
    }

    @Override
    public ScreenDockStationLayout read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        boolean version8;
        Version version = Version.read(in);
        version.checkCurrent();
        boolean bl = version8 = version.compareTo(Version.VERSION_1_0_8) >= 0;
        if (version8) {
            PlaceholderMap map = new PlaceholderMap(in, placeholders);
            return new ScreenDockStationLayout(map);
        }
        RetroScreenDockStationLayout layout = new RetroScreenDockStationLayout();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            int id = in.readInt();
            int x = in.readInt();
            int y = in.readInt();
            int width = in.readInt();
            int height = in.readInt();
            layout.add(id, x, y, width, height);
        }
        return layout;
    }

    @Override
    public void write(ScreenDockStationLayout layout, XElement element) {
        if (layout instanceof RetroScreenDockStationLayout) {
            RetroScreenDockStationLayout retro = (RetroScreenDockStationLayout)layout;
            int n = retro.size();
            for (int i = 0; i < n; ++i) {
                XElement child = element.addElement("child");
                child.addInt("id", retro.id(i));
                child.addInt("x", retro.x(i));
                child.addInt("y", retro.y(i));
                child.addInt("width", retro.width(i));
                child.addInt("height", retro.height(i));
            }
        } else {
            layout.getPlaceholders().write(element.addElement("placeholders"));
        }
    }

    @Override
    public ScreenDockStationLayout read(XElement element, PlaceholderStrategy placeholders) {
        XElement xplaceholders = element.getElement("placeholders");
        if (xplaceholders != null) {
            return new ScreenDockStationLayout(new PlaceholderMap(xplaceholders, placeholders));
        }
        RetroScreenDockStationLayout layout = new RetroScreenDockStationLayout();
        for (XElement child : element.getElements("child")) {
            layout.add(child.getInt("id"), child.getInt("x"), child.getInt("y"), child.getInt("width"), child.getInt("height"));
        }
        return layout;
    }

    protected ScreenDockStation createStation() {
        return new ScreenDockStation(this.owner);
    }
}

