/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.focus.DockableSelectionListener;
import java.awt.Component;

public class ThemeDockableSelection
implements DockableSelection {
    private DockController controller;
    private DockableSelection current;
    private DockableSelectionListener listener = new DockableSelectionListener(){

        public void selected(Dockable dockable) {
            ThemeDockableSelection.this.closed();
        }

        public void considering(Dockable dockable) {
        }

        public void canceled() {
            ThemeDockableSelection.this.closed();
        }
    };

    public ThemeDockableSelection(DockController controller) {
        this.controller = controller;
    }

    private DockableSelection get() {
        if (this.current != null) {
            return this.current;
        }
        return this.controller.getTheme().getDockableSelection(this.controller);
    }

    private void closed() {
        if (this.current != null) {
            this.current.removeDockableSelectionListener(this.listener);
            this.current = null;
        }
    }

    public void addDockableSelectionListener(DockableSelectionListener listener) {
        this.get().addDockableSelectionListener(listener);
    }

    public void close() {
        this.get().close();
        this.closed();
    }

    public Component getComponent() {
        return this.get().getComponent();
    }

    public boolean hasChoices(DockController controller) {
        return this.get().hasChoices(controller);
    }

    public void open(DockController controller) {
        if (this.current == null) {
            this.current = this.get();
            this.current.addDockableSelectionListener(this.listener);
        }
        this.current.open(controller);
    }

    public void removeDockableSelectionListener(DockableSelectionListener listener) {
        this.get().removeDockableSelectionListener(listener);
    }
}

