% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diags.R
\name{summarize_spew}
\alias{summarize_spew}
\title{Summarize a SPEW region}
\usage{
summarize_spew(filenames, marginals = NULL, vars_to_sum, env_vars = NULL,
  coords = TRUE, samp_size = 10^4, read = FALSE, pops = NULL,
  type = NULL)
}
\arguments{
\item{filenames}{list of full path to files to summarize and the id of the region}

\item{marginals}{list containing all of the marginal totals.  See ?make_ipf_marg for more details.  Default is NULL}

\item{vars_to_sum}{variables we wish to summarize, should correspond to marginals object}

\item{env_vars}{environment variables to summarize.  Default is NULL}

\item{coords}{logical of whether to extract the longitude/latitude coordinates and store}

\item{samp_size}{number of lon/lat coordinates to sample.  Default is 10^4}

\item{read}{logical of whether we need to read in the populations.  Default is FALSE}

\item{pops}{list of the populations produced by SPEW for a household OR people}

\item{type}{either NULL, "households", or "people".}
}
\value{
a list of length of  1 for the  region ID , 1 for population size, and optionally one for a dataframe of stored lat/long coords, the number of variables to summarize , and the environmental variables
}
\description{
Summarize a SPEW region
}
