% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_sp-network-nodes.R
\name{sp_network_nodes}
\alias{sp_network_nodes}
\title{Create a \code{\link[=sp_network_nodes-class]{sp_network_nodes-class()}}}
\usage{
sp_network_nodes(
  network_id,
  node_neighborhood = NULL,
  node_data = NULL,
  node_key_column
)
}
\arguments{
\item{network_id}{A character that serves as an identifier for the network}

\item{node_neighborhood}{A matrix that describes the neighborhood of the nodes}

\item{node_data}{A data.frame that contains all information describing the nodes}

\item{node_key_column}{A character indicating the column containing the identifiers for the nodes}
}
\value{
An S4 class of type \code{\link[=sp_network_nodes-class]{sp_network_nodes-class()}}
}
\description{
Create a \code{\link[=sp_network_nodes-class]{sp_network_nodes-class()}}
}
\examples{
sp_network_nodes("germany",
                 spdep::nb2mat(spdep::poly2nb(germany_grid)),
                 as.data.frame(germany_grid),
                 "ID_STATE")
}
\seealso{
Other Constructors for spflow network classes: 
\code{\link{sp_multi_network}},
\code{\link{sp_network_pair}},
\code{\link{spflow_network_classes}}
}
\concept{Constructors for spflow network classes}
