% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spflow-package.R
\docType{package}
\name{spflow-package}
\alias{spflow-package}
\alias{_PACKAGE}
\title{Spatial econometric interaction models in R}
\description{
The \code{spflow} package provides function to estimate models of
origin-destination flows with spatial autocorrelation.
The implementation exploits the efficiency gains of the matrix formulation
that avoids duplication of the data that describes the origins and
the destinations.
It offers new data structures and a convenient formula interface
that allows to estimate the models with maximal efficiency and minimal
effort for the user.
The estimators are detailed in \insertCite{Dargel2021;textual}{spflow}.
}
\section{Network data}{

The package provides a new class for representing network data.
\link[=spflow_network_classes]{These classes} help to exploit the relational
structure of the data and ensure that all origins and destinations are
correctly identified.
}

\section{Model estimation}{

The \code{\link[=spflow]{spflow()}} function is the main function for estimation and can be used
out of the box using the default configuration, which corresponds to the
most general model possible.
Fine grained control over the estimation procedure is given via the
\code{\link[=spflow_control]{spflow_control()}} argument through which the user can change, for example,
the estimation method or the way in which the covariates should be used.
}

\references{
\insertAllCited{}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/LukeCe/spflow}
  \item Report bugs at \url{https://github.com/LukeCe/spflow/issues}
}

}
\author{
\strong{Maintainer}: Lukas Dargel \email{lukas.dargel@mailbox.org} (\href{https://orcid.org/0000-0002-4839-506X}{ORCID})

Authors:
\itemize{
  \item Thibault Laurent \email{thibault.laurent@tse-fr.eu} (\href{https://orcid.org/0000-0001-7487-7671}{ORCID})
}

Other contributors:
\itemize{
  \item Christine Thomas \email{christine.thomas@tse-fr.eu} [thesis advisor, contributor]
  \item Paula Margaretic [contributor]
  \item Gabriel Watkinson [contributor]
  \item Roger Bivand [contributor]
}

}
\keyword{internal}
