% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spidR.R
\name{taxonomy}
\alias{taxonomy}
\title{Get higher taxa from species.}
\usage{
taxonomy(tax, order = FALSE)
}
\arguments{
\item{tax}{A taxon name or vector with taxa names.}

\item{order}{Order species names alphabetically or keep as in tax.}
}
\value{
A data.frame with species and taxonomy.
}
\description{
Get species sub/infraorder, family and genus from the World Spider Catalogue.
}
\details{
This function will get species sub/infraorder, family and genus from the World Spider Catalogue (2021).
}
\examples{
\dontrun{
taxonomy("Symphytognathidae", order = TRUE)
taxonomy(c("Iberesia machadoi", "Nemesia bacelarae", "Amphiledorus ungoliantae"))
}
}
\references{
World Spider Catalog (2021). World Spider Catalog. Version 22.0. Natural History Museum Bern, online at http://wsc.nmbe.ch. doi: 10.24436/2.
}
