% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_visualize.r
\name{play_manual_tour}
\alias{play_manual_tour}
\title{Animate a manual tour}
\usage{
play_manual_tour(
  basis = NULL,
  data,
  render_type = render_plotly,
  rescale_data = FALSE,
  ...
)
}
\arguments{
\item{basis}{A (p, d) orthonormal numeric matrix.
The linear combination the original variables contribute to projection space.
Defaults to NULL, generating a random basis.}

\item{data}{(n, p) dataset to project, consisting of numeric variables.}

\item{render_type}{Which graphics to render to. Defaults to render_plotly,}

\item{rescale_data}{When TRUE scales the data to between 0 and 1.}

\item{...}{Optionally pass additional arguments to the \code{render_type} for
plotting options.}
}
\value{
An animation of a radial tour.
}
\description{
Performs the a manual tour and returns an animation of \code{render_type}.
For use with \code{tourr::save_history()} tour paths see \code{play_tour_path()}.
}
\examples{
flea_std <- tourr::rescale(tourr::flea[,1:6])
rb <- tourr::basis_random(n = ncol(flea_std))
class <- tourr::flea$species

\dontrun{
play_manual_tour(basis = rb, data = flea_std, manip_var = 4)

play_manual_tour(basis = rb, data = flea_std, manip_var = 6, theta = .5 * pi,
                 render_type = render_gganimate, col = class, pch = class, 
                 axes = "bottomleft", fps = 5)
}
}
