% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_visualize.r
\name{oblique_basis}
\alias{oblique_basis}
\title{Return the basis of an oblique frame}
\usage{
oblique_basis(basis = NULL, manip_var, theta = NULL, phi = NULL)
}
\arguments{
\item{basis}{A (p, d) orthonormal numeric matrix.
The linear combination the original variables contribute to projection space.
Defaults to NULL, generating a random basis.}

\item{manip_var}{Number of the column/dimension to rotate.}

\item{theta}{Angle in radians of "in-plane" rotation, on the xy plane of the
reference frame. Required, no default.
If left NULL, will initialize the radial angle of the \code{manip_var}.`}

\item{phi}{Phi is angle in radians of
the "out-of-plane" rotation, the z-axis of the reference frame.
Required, no default.}
}
\value{
(p, 2) matrix of the rotated basis.
}
\description{
Rotates a basis returning (p, 2) basis describing \code{oblique_frame()}
Used to create an oblique tour by small changes to the rotation.
}
\examples{
rb    <- tourr::basis_random(n = 6)
theta <- runif(1, 0, 2*pi)
phi   <- runif(1, 0, 2*pi)

oblique_basis(basis = rb, manip_var = 4, theta, phi)
}
