% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{view_basis}
\alias{view_basis}
\title{Plot the axes directions of the basis table without data points.}
\usage{
view_basis(basis, data = NULL, lab = NULL, axes = "center", ...)
}
\arguments{
\item{basis}{A (p, d) orthonormal numeric matrix.
The linear combination the original variables contribute to projection space.
Required, no default.}

\item{data}{Optional (n, p) data to plot on through the projection basis.}

\item{lab}{Optional, labels for the reference frame of length 1 or the
number of variables used. By default will abbreviate data if available.}

\item{axes}{Position of the axes: "center", "bottomleft" or "off". Defaults
to "center".}

\item{...}{Optionally passes arguments to the projection points inside the
aesthetics; \code{geom_point(aes(...))}.}
}
\value{
ggplot object of the basis.
}
\description{
ggplot2 object of axes contribution inscribed in a unit circle.
}
\examples{
rb <- tourr::basis_random(4, 2)
view_basis(basis = rb)

flea_std <- tourr::rescale(tourr::flea[, 1:4])
view_basis(basis = rb, data = flea_std, axes = "bottomleft")

view_basis(basis = rb, data = flea_std, axes = "right", 
           col = col_of(tourr::flea[, 7], "Paired"), 
           pch = pch_of(tourr::flea[,7]),
           alpha = .7, size = 2)
}
