% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_visualize.r
\name{view_frame}
\alias{view_frame}
\title{Plot a single frame of a manual tour}
\usage{
view_frame(
  basis = NULL,
  data = NULL,
  manip_var = NULL,
  theta = 0L,
  phi = 0L,
  label = abbreviate(row.names(basis), 3L),
  rescale_data = FALSE,
  ...
)
}
\arguments{
\item{basis}{A (p, d) dim orthonormal numeric matrix.
Defaults to NULL, giving a random basis.}

\item{data}{A (n, p) dataset to project, consisting of numeric variables.}

\item{manip_var}{Optional, number of the variable to rotate.
If NULL, theta and phi must be 0 as is no manip space to rotate.}

\item{theta}{Angle in radians of "in-projection plane" rotation,
on the xy plane of the reference frame. Defaults to 0, no rotation.}

\item{phi}{Angle in radians of the "out-of-projection plane" rotation, into
the z-direction of the axes. Defaults to 0, no rotation.}

\item{label}{Optionally, provide a character vector of length p (or 1)
to label the variable contributions to the axes, Default NULL,
results in a 3 character abbreviation of the variable names.}

\item{rescale_data}{When TRUE scales the data to between 0 and 1.
Defaults to FALSE.}

\item{...}{Optionally pass additional arguments to the \code{render_type} for
projection point aesthetics;}
}
\value{
A ggplot object of the rotated projection.
}
\description{
Projects the specified rotation as a 2D ggplot object. One static frame of
manual tour. Useful for providing user-guided interaction.
}
\examples{
dat_std <- scale_sd(wine[, 2:14])
clas <- wine$Type
bas <- basis_pca(dat_std)
mv <- manip_var_of(bas)

view_frame(basis = bas)

view_frame(basis = bas, data = dat_std, manip_var = mv)

rtheta <- runif(1, 0, 2 * pi)
rphi   <- runif(1, 0, 2 * pi)
view_frame(basis = bas, data = dat_std, manip_var = mv,
           theta = rtheta, phi = rphi, label = paste0("MyNm", 1:ncol(dat_std)), 
           aes_args = list(color = clas, shape = clas),
           identity_args = list(size = 1.5, alpha = .7),
           ggproto = list(ggplot2::theme_void(), ggplot2::ggtitle("My title")))
}
