% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{proto_point}
\alias{proto_point}
\alias{proto_points}
\title{Tour proto for data point}
\usage{
proto_point(aes_args = list(), identity_args = list())
}
\arguments{
\item{aes_args}{A list of aesthetic arguments to passed to
\verb{geom_point(aes(X)}. Any mapping of the data to an aesthetic,
for example, \code{geom_point(aes(color = myCol, shape = myCol))} becomes
\code{aes_args = list(color = myCol, shape = myCol)}.}

\item{identity_args}{A list of static, identity arguments passed into
\code{geom_point()}, but outside of \code{aes()}, for instance
\code{geom_point(aes(...), size = 2, alpha = .7)} becomes
\code{identity_args = list(size = 2, alpha = .7)}.}
}
\description{
Adds \code{geom_point()} of the projected data.
}
\examples{
dat <- scale_sd(tourr::flea[, 1:6])
clas <- tourr::flea$species
gt_path <- tourr::save_history(dat, grand_tour(), max_bases = 5)

ggt <- ggtour(gt_path, dat, angle = .1) +
  proto_point()
\dontrun{
animate_plotly(ggt)}

ggt2 <- ggtour(gt_path, dat) +
  proto_point(list(color = clas, shape = clas),
              list(size = 2, alpha = .7))
\dontrun{
animate_plotly(ggt2)}
}
\seealso{
Other ggtour proto: 
\code{\link{filmstrip}()},
\code{\link{ggtour}()},
\code{\link{proto_basis}()},
\code{\link{proto_default}()},
\code{\link{proto_density}()},
\code{\link{proto_hex}()},
\code{\link{proto_highlight}()},
\code{\link{proto_origin}()},
\code{\link{proto_text}()}
}
\concept{ggtour proto}
