% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmqn_step.r
\name{wood_inv_solve}
\alias{wood_inv_solve}
\title{Compute the inverse approximate Hessian of the majorization using the Woodbury inversion formula.
\code{wood_inv_solve} computes the inverse of the Hessian term of the majorization of the proximity function
using the Woodbury formula. The function \code{mmqn_step} invokes \code{wood_inv_solve} instead of {ddg} if the argument
\code{woodbury=TRUE}. This should be used when p << n.}
\usage{
wood_inv_solve(x, v, w, hgrad, df)
}
\arguments{
\item{x}{non-anchor point}

\item{v}{weights for first set of constraints}

\item{w}{weights for second set of constraints}

\item{hgrad}{Handle for output mapping Jacobian}

\item{df}{Right hand side}
}
\description{
Compute the inverse approximate Hessian of the majorization using the Woodbury inversion formula.
\code{wood_inv_solve} computes the inverse of the Hessian term of the majorization of the proximity function
using the Woodbury formula. The function \code{mmqn_step} invokes \code{wood_inv_solve} instead of {ddg} if the argument
\code{woodbury=TRUE}. This should be used when p << n.
}
