% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm12_condition.R
\name{spm12_condition}
\alias{spm12_condition}
\alias{spm12_condition_list}
\title{Build Conditions for SPM12 first level model}
\usage{
spm12_condition(
  name,
  onset,
  duration,
  time_mod_order = 0,
  param_mod = NULL,
  orth = TRUE
)

spm12_condition_list(cond)
}
\arguments{
\item{name}{Name of the condition}

\item{onset}{vector of onset of the condition}

\item{duration}{vector of duration of the condition, 
must be the same length as \code{onset}}

\item{time_mod_order}{time modulation order. 
This option allows for the characterization of linear or 
nonlinear time effects. Zero means no modulation}

\item{param_mod}{parametric modulation.  Not currently
supported in \code{spm12r}}

\item{orth}{Orthogonalize the regressors within trial types.}

\item{cond}{List of conditions}
}
\value{
A list of objects, each with a \code{name}, \code{onset}, 
\code{duration}, and other condition values.
}
\description{
Build Conditions for SPM12 first level model
}
\examples{
res = spm12_condition(
name = "condition1", 
onset = c(0, 2, 4, 6, 8),
duration = rep(1, 5) )
print(res)
L = list(
cond1 = list(onset = c(0, 2, 4, 6, 8), duration = rep(1, 5)), 
cond2 = list(onset = c(0, 2, 4, 6, 8) + 1, duration = rep(1, 5))
)
res = spm12_condition_list(L)
print(res) 
}
