% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.spmod}
\alias{predict.spmod}
\title{Model predictions (Kriging)}
\usage{
\method{predict}{spmod}(
  object,
  newdata,
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  local,
  ...
)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{newdata}{A data frame or \code{sf} object in which to
look for variables with which to predict. If a data frame, \code{newdata}
must contain all variables used by \code{formula(object)} and all variables
representing coordinates. If an \code{sf} object, \code{newdata} must contain
all variables used by \code{formula(object)} and coordinates are obtained
from the geometry of \code{newdata}. If omitted, missing data from the
fitted model object are used.}

\item{se.fit}{A logical indicating if standard errors are returned.
The default is \code{FALSE}.}

\item{interval}{Type of interval calculation. The default is \code{"none"}.
Other options are \code{"confidence"} (for confidence intervals) and
\code{"prediction"} (for prediction intervals).}

\item{level}{Tolerance/confidence level. The default is \code{0.95}.}

\item{local}{A optional logical or list controlling the big data approximation. If omitted, \code{local}
is set to \code{TRUE} or \code{FALSE} based on the sample size of the fitted
model object and/or the prediction size of \code{newdata} -- if the sample
size or prediction size exceeds 5000, \code{local} is
set to \code{TRUE}, otherwise it is set to \code{FALSE}. If \code{FALSE}, no big data approximation
is implemented. If a list is provided, the following arguments detail the big
data approximation:
\itemize{
\item{\code{method}: }{The big data approximation method. If \code{method = "all"},
all observations are used and \code{size} is ignored. If \code{method = "distance"},
the \code{size} data observations closest (in terms of Euclidean distance)
to the observation requiring prediction are used.
If \code{method = "covariance"}, the \code{size} data observations
with the highest covariance with the observation requiring prediction are used.
If random effects and partition factors are not used in estimation and
the spatial covariance function is monotone decreasing,
\code{"distance"} and \code{"covariance"} are equivalent. The default
is \code{"covariance"}. Only used with models fit using \code{\link[=splm]{splm()}}.}
\item{\code{size}: }{The number of data observations to use when \code{method}
is \code{"distance"} or \code{"covariance"}. The default is 50. Only used
with models fit using \code{\link[=splm]{splm()}}.}
\item{\code{parallel}: }{If \code{TRUE}, parallel processing via the
parallel package is automatically used. The default is \code{FALSE}.}
\item{\code{ncores}: }{If \code{parallel = TRUE}, the number of cores to
parallelize over. The default is the number of available cores on your machine.}
}
When \code{local} is a list, at least one list element must be provided to
initialize default arguments for the other list elements.
If \code{local} is \code{TRUE}, defaults for \code{local} are chosen such
that \code{local} is transformed into
\code{list(size = 50, method = "covariance", parallel = FALSE)}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
If \code{se.fit} is \code{FALSE}, \code{predict.spmod()} returns
a vector of predictions or a matrix of predictions with column names
\code{fit}, \code{lwr}, and \code{upr} if \code{interval} is \code{"confidence"}
or \code{"prediction"}.

If \code{se.fit} is \code{TRUE}, a list with the following components is returned:
\itemize{
\item{\code{fit}: }{vector or matrix as above}
\item{\code{se.fit: }}{standard error of each fit}
}
}
\description{
Predicted values and intervals based on a fitted model object.
}
\details{
The (empirical) best linear unbiased predictions (i.e., Kriging
predictions) at each site are returned when \code{interval} is \code{"none"}
or \code{"prediction"} alongside standard errors. Prediction intervals
are also returned if \code{interval} is \code{"prediction"}. When
\code{interval} is \code{"confidence"}, the estimated mean is returned
alongside standard errors and confidence intervals for the mean.
}
\examples{
spmod <- splm(sulfate ~ 1,
  data = sulfate,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
predict(spmod, sulfate_preds)
predict(spmod, sulfate_preds, interval = "prediction")
augment(spmod, newdata = sulfate_preds, interval = "prediction")
}
