% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R, R/augment_glm.R
\name{augment.spmodel}
\alias{augment.spmodel}
\alias{augment.splm}
\alias{augment.spautor}
\alias{augment.spglm}
\alias{augment.spgautor}
\title{Augment data with information from fitted model objects}
\usage{
\method{augment}{splm}(
  x,
  drop = TRUE,
  newdata = NULL,
  se_fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  local,
  ...
)

\method{augment}{spautor}(
  x,
  drop = TRUE,
  newdata = NULL,
  se_fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  local,
  ...
)

\method{augment}{spglm}(
  x,
  drop = TRUE,
  newdata = NULL,
  type.predict = c("link", "response"),
  type.residuals = c("deviance", "pearson", "response"),
  se_fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  newdata_size,
  level = 0.95,
  local = local,
  var_correct = TRUE,
  ...
)

\method{augment}{spgautor}(
  x,
  drop = TRUE,
  newdata = NULL,
  type.predict = c("link", "response"),
  type.residuals = c("deviance", "pearson", "response"),
  se_fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  newdata_size,
  level = 0.95,
  local,
  var_correct = TRUE,
  ...
)
}
\arguments{
\item{x}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{drop}{A logical indicating whether to drop extra variables in the
fitted model object \code{x} when augmenting. The default for \code{drop} is \code{TRUE}.
\code{drop} is ignored if augmenting \code{newdata}.}

\item{newdata}{A data frame or tibble containing observations requiring prediction.
All of the original explanatory variables used to create the fitted model object \code{x}
must be present in \code{newdata}. Defaults to \code{NULL}, which indicates
that nothing has been passed to \code{newdata}.}

\item{se_fit}{Logical indicating whether or not a \code{.se.fit} column should
be added to augmented output. Passed to \code{predict()} and
defaults to \code{FALSE}.}

\item{interval}{Character indicating the type of confidence interval columns to
add to the augmented \code{newdata} output. Passed to \code{predict()} and defaults
to \code{"none"}.}

\item{level}{Tolerance/confidence level. The default is \code{0.95}.}

\item{local}{A list or logical. If a list, specific list elements described
in \code{\link[=predict.spmodel]{predict.spmodel()}} control the big data approximation behavior.
If a logical, \code{TRUE} chooses default list elements for the list version
of \code{local} as specified in \code{\link[=predict.spmodel]{predict.spmodel()}}. Defaults to \code{FALSE},
which performs exact computations.}

\item{...}{Other arguments. Not used (needed for generic consistency).}

\item{type.predict}{The scale (\code{response} or \code{link}) of fitted
values and predictions obtained using \code{spglm()} or \code{spgautor} objects.}

\item{type.residuals}{The residual type (\code{deviance}, \code{pearson}, or \code{response})
of fitted models from \code{spglm()} or \code{spgautor} objects. Ignored if
\code{newdata} is specified.}

\item{newdata_size}{The \code{size} value for each observation in \code{newdata}
used when predicting for the binomial family.}

\item{var_correct}{A logical indicating whether to return the corrected prediction
variances when predicting via models fit using \code{spglm()} or \code{spgautor()}. The default is
\code{TRUE}.}
}
\value{
When augmenting the original data set, a tibble with additional columns
\itemize{
\item \code{.fitted} Fitted value
\item \code{.resid} Response residual (the difference between observed and fitted values)
\item \code{.hat} Leverage (diagonal of the hat matrix)
\item \code{.cooksd} Cook's distance
\item \code{.std.resid} Standardized residuals
\item \code{.se.fit} Standard error of the fitted value.
}

When augmenting a new data set, a tibble with additional columns
\itemize{
\item \code{.fitted} Predicted (or fitted) value
\item \code{.lower} Lower bound on interval
\item \code{.upper} Upper bound on interval
\item \code{.se.fit} Standard error of the predicted (or fitted) value
}
}
\description{
Augment accepts a fitted model object and a data set and adds
information about each observation in the data set. New columns always
begin with a \code{.} prefix to avoid overwriting columns in the original
data set.

Augment behaves differently depending on whether the original data or new data
requires augmenting. Typically, when augmenting the original data, only the fitted
model object is specified, and when augmenting new data, the fitted model object
and \code{newdata} is specified. When augmenting the original data, diagnostic
statistics are augmented to each row in the data set. When augmenting new data,
predictions and optional intervals or standard errors are augmented to each
row in the new data set.
}
\details{
\code{augment()} returns a tibble with the same class as
\code{data}. That is, if \code{data} is
an \code{sf} object, then the augmented object (obtained via \code{augment(x)})
will be an \code{sf} object as well. When augmenting \code{newdata}, the
augmented object has the same class as \code{data}.

Missing response values from the original data can be augmented as if
they were a \code{newdata} object by providing \code{x$newdata} to the
\code{newdata} argument (where \code{x} is the name of the fitted model
object). This is the only way to compute predictions for
\code{\link[=spautor]{spautor()}} and \code{\link[=spgautor]{spgautor()}} fitted model objects.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
augment(spmod)
spmod_sulf <- splm(sulfate ~ 1, data = sulfate, spcov_type = "exponential")
augment(spmod_sulf)
augment(spmod_sulf, newdata = sulfate_preds)
# missingness in original data
spmod_seal <- spautor(log_trend ~ 1, data = seal, spcov_type = "car")
augment(spmod_seal)
augment(spmod_seal, newdata = spmod_seal$newdata)
}
\seealso{
\code{\link[=tidy.spmodel]{tidy.spmodel()}} \code{\link[=glance.spmodel]{glance.spmodel()}} \code{\link[=predict.spmodel]{predict.spmodel()}}
}
