% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loocv.R, R/loocv_glm.R
\name{loocv}
\alias{loocv}
\alias{loocv.splm}
\alias{loocv.spautor}
\alias{loocv.spglm}
\alias{loocv.spgautor}
\title{Perform leave-one-out cross validation}
\usage{
loocv(object, ...)

\method{loocv}{splm}(object, cv_predict = FALSE, se.fit = FALSE, local, ...)

\method{loocv}{spautor}(object, cv_predict = FALSE, se.fit = FALSE, local, ...)

\method{loocv}{spglm}(object, cv_predict = FALSE, se.fit = FALSE, local, ...)

\method{loocv}{spgautor}(object, cv_predict = FALSE, se.fit = FALSE, local, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}

\item{cv_predict}{A logical indicating whether the leave-one-out fitted values
should be returned. Defaults to \code{FALSE}. If \code{object} is from \code{\link[=spglm]{spglm()}} or \code{\link[=spgautor]{spgautor()}},
the fitted values returned are on the link scale.}

\item{se.fit}{A logical indicating whether the leave-one-out
prediction standard errors should be returned. Defaults to \code{FALSE}.
If \code{object} is from \code{\link[=spglm]{spglm()}} or \code{\link[=spgautor]{spgautor()}},
the standard errors correspond to the fitted values returned on the link scale.}

\item{local}{A list or logical. If a list, specific list elements described
in \code{\link[=predict.spmodel]{predict.spmodel()}} control the big data approximation behavior.
If a logical, \code{TRUE} chooses default list elements for the list version
of \code{local} as specified in \code{\link[=predict.spmodel]{predict.spmodel()}}. Defaults to \code{FALSE},
which performs exact computations.}
}
\value{
If \code{cv_predict = FALSE} and \code{se.fit = FALSE},
a fit statistics tibble (with bias, MSPE, RMSPE, and cor2; see Details).
If \code{cv_predict = TRUE} or \code{se.fit = TRUE},
a list with elements: \code{stats}, a fit statistics tibble
(with bias, MSPE, RMSPE, and cor2; see Details); \code{cv_predict}, a numeric vector
with leave-one-out predictions for each observation (if \code{cv_predict = TRUE});
and \code{se.fit}, a numeric vector with leave-one-out prediction standard
errors for each observation (if \code{se.fit = TRUE}).
}
\description{
Perform leave-one-out cross validation with options for computationally
efficient approximations for big data.
}
\details{
Each observation is held-out from the data set and the remaining data
are used to make a prediction for the held-out observation. This is compared
to the true value of the observation and several fit statistics are computed:
bias, mean-squared-prediction error (MSPE), root-mean-squared-prediction
error (RMSPE), and the squared correlation (cor2) between the observed data
and leave-one-out predictions (regarded as a prediction version of r-squared
appropriate for comparing across spatial and nonspatial models). Generally,
bias should be near zero for well-fitting models. The lower the MSPE and RMSPE,
the better the model fit (according to the leave-out-out criterion).
The higher the cor2, the better the model fit (according to the leave-out-out
criterion). cor2 is not returned when \code{object} was fit using
\code{spglm()} or \code{spgautor()}, as it is only applicable here for linear models.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
loocv(spmod)
loocv(spmod, cv_predict = TRUE, se.fit = TRUE)
}
