% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SpatialNetwork.r
\name{spnet.create}
\alias{spnet.create}
\title{Create a \code{SpatialNetwork} object}
\usage{
spnet.create(x, map, networks, plot.title = list(main =
  "Untitled SPNET object", sub = "", cex = 2, col = "#333333"),
  plot.label = list(cex = 1, col = "#333333"), plot.color,
  plot.blackwhite = list(enable = FALSE, min = 0.02, max = 0.98), plot.symbol,
  plot.barplot = list(variable = "", bound.lower = c(-0.5, -0.5), bound.upper
  = c(0.5, -0.5), fgcolor = "#666666", bgcolor = "#eeeeee", width = 8),
  plot.arrow, plot.legend = list(print = TRUE, cex = 1, ncol = 1, horiz =
  FALSE, lwd = 1), plot.layout = list(ratios = c(title = 1/10, graphic = 7/10,
  legend = 2/10), mat = NULL, reset = TRUE), plot.par = list(mar = c(1, 1, 1,
  1)), infos, quiet = FALSE)
}
\arguments{
\item{x}{a \code{data.frame} containing at least two columns: \code{NODE} and \code{POSITION}.}

\item{map}{a \code{\link[sp]{SpatialPolygons}} object.}

\item{networks}{a list of the networks to plot.}

\item{plot.title}{a list of parameters for setting the title.}

\item{plot.label}{a list of parameters to be passed to the \code{\link{text}} function for setting labels.}

\item{plot.color}{a list of parameters for setting colors.}

\item{plot.blackwhite}{a list of parameters for setting the black and white mode.}

\item{plot.symbol}{a list of parameters for setting symbols.}

\item{plot.barplot}{a list of parameters for setting barplots.}

\item{plot.arrow}{a list of parameters for setting arrows.}

\item{plot.legend}{a list of parameters for setting the legend.}

\item{plot.layout}{a list of parameters for setting the layout.}

\item{plot.par}{a list of graphical parameters.}

\item{infos}{a list of meta information about the instance of the object.}

\item{quiet}{= FALSE a logical, suppress all messages.}
}
\description{
The \code{spnet.create} function is the official builder for creating \code{SpatialNetwork} objects.
}
\examples{
people <- c("John", "Elsa", "Brian", "Kate")
position <- c(2,4,6,8)

net1.df <- data.frame(
  'NODE' = people,
  'POSITION' = position
)

net1 <- spnet.create(
  x = net1.df
)
net1

net2 <- spnet.create(
  x = people
)
net2
}
\author{
Emmanuel Rousseaux
}

