% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/methods.r, R/occ_names.R
\name{spocc_objects}
\alias{plot.occdat}
\alias{print.occdat}
\alias{print.occdatind}
\alias{print.occnames}
\alias{spocc_objects}
\alias{summary.occdat}
\alias{summary.occdatind}
\title{spocc objects and their print, plot, and summary methods}
\usage{
\method{print}{occdat}(x, ...)

\method{print}{occdatind}(x, ..., n = 10)

\method{summary}{occdat}(object, ...)

\method{summary}{occdatind}(object, ...)

\method{plot}{occdat}(x, ...)

\method{print}{occnames}(x, ...)
}
\arguments{
\item{x}{Input, of class occdatind}

\item{...}{Further args to print, plot or summary methods}

\item{n}{Number of rows to show. If \code{NULL}, the default, will print
  all rows if less than option \code{dplyr.print_max}. Otherwise, will
  print \code{dplyr.print_min}}

\item{object}{Input to summary methods}
}
\description{
spocc objects and their print, plot, and summary methods
}
\examples{
\dontrun{
# occdat object
res <- occ(query = 'Accipiter striatus', from = 'gbif')
res
print(res)
is(res)

# occdatind object
res$gbif
print(res$gbif)
is(res$gbif)

# print summary of occdat object
summary(res)

# print summary of occdatind object
summary(res$gbif)

# plot an occdat object
spnames <- c('Accipiter striatus', 'Setophaga caerulescens', 'Spinus tristis')
out <- occ(query=spnames, from='gbif', gbifopts=list(hasCoordinate=TRUE))
plot(out, cex=1, pch=10)
}
}
\keyword{internal}

