% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.bison.R
\name{as.bison}
\alias{as.bison}
\title{Coerce occurrence keys to bisonkey/occkey objects}
\usage{
as.bison(x)
}
\arguments{
\item{x}{Various inputs, including the output from a call to \code{\link{occ}} 
(class occdat), \code{\link{occ2df}} (class data.frame), or a list, numeric, 
character, or bisonkey, or occkey.}
}
\value{
One or more in a list of both class bisonkey and occkey
}
\description{
Coerce occurrence keys to bisonkey/occkey objects
}
\details{
Internally, we use \code{\link[rbison]{bison_solr}}, same function we use  
internally within the \code{\link{occ}} function. Although, we query here with the 
\code{occurrenceID} parameter to get the occurrence directly instead of searching for it.
}
\examples{
\dontrun{
spnames <- c('Accipiter striatus', 'Setophaga caerulescens', 'Carduelis tristis')
out <- occ(query=spnames, from='bison', limit=2)
res <- occ2df(out)
(tt <- as.bison(out))
(uu <- as.bison(res))
as.bison(as.numeric(res$key[1]))
as.bison(res$key[1])
as.bison(as.list(res$key[1:2]))
as.bison(tt[[1]])
as.bison(uu[[1]])
as.bison(tt[1:2])
}
}

