% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ignition_point.R
\name{ignition_point}
\alias{ignition_point}
\title{Calculation of the ignition points}
\usage{
ignition_point(lon, lat, obsTime, timeUnit, timeID, membership, ignitionCenter)
}
\arguments{
\item{lon}{Numeric. A vector of longitude values.}

\item{lat}{Numeric. A vector of latitude values.}

\item{obsTime}{Date/Datetime/Numeric. A vector of observed time.}

\item{timeUnit}{Character. One of "s" (seconds), "m"(minutes),
"h"(hours), "d"(days) and "n"(numeric).}

\item{timeID}{Integer (>=1). A vector of time indexes.}

\item{membership}{Integer. A vector of membership labels.}

\item{ignitionCenter}{Character. Method of calculating ignition points,
one of "mean" and "median".}
}
\value{
A data frame of ignition points
\itemize{
\item \code{membership} : Membership labels.
\item \code{lon} : Longitude of ignition points.
\item \code{lat} : Latitude of ignition points.
\item \code{obsTime} : Observed time of ignition points.
\item \code{timeID} : Time indexes.
\item \code{obsInCluster} : Number of observations in the cluster.
\item \code{clusterTimeLen} : Length of time of the cluster.
\item \code{clusterTimeLenUnit} : Unit of length of time of the cluster.
}
}
\description{
This function calculates ignition points for all clusters.
}
\details{
For more details about the clustering algorithm and the argument
\code{timeUnit}, \code{timeID} and \code{ignitionCenter},
please check the documentation of \code{\link[=hotspot_cluster]{hotspot_cluster()}}.
This function performs the \strong{step 5} of the clustering algorithm. It
calculates ignition points.
For a cluster, when there are multiple earliest hot spots, if
\code{ignitionCenter} is "mean", the centroid of these hot spots will be used
as the ignition point. If \code{ignitionCenter} is "median", median longitude
and median latitude of these hot spots will be used.
}
\examples{

# Define lon, lat, obsTime, timeID and membership for 10 observations
lon <- c(141.1, 141.14, 141.12, 141.14, 141.16, 141.12, 141.14,
          141.16, 141.12, 141.14)
lat <- c(-37.10, -37.10, -37.12, -37.12, -37.12, -37.14, -37.14,
         -37.14, -37.16, -37.16)
obsTime <- c(rep(1, 5), rep(26, 5))
timeUnit <- "n"
timeID <- c(rep(1, 5), rep(26, 5))
membership <- c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2)

# Calculate the ignition points using different methods
ignition_point(lon, lat, obsTime, timeUnit, timeID, membership, "mean")
ignition_point(lon, lat, obsTime, timeUnit, timeID, membership, "median")

}
