% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{LocalGi}
\alias{LocalGi}
\title{Local Getis-Ord Gi or Gi* statistics for spatial hot spot analysis}
\usage{
LocalGi(
  X,
  W,
  gstar = TRUE,
  alternative = c("two.sided", "less", "greater"),
  p.adjust.method = "BH"
)
}
\arguments{
\item{X}{A matrix with observations as rows and features as columns.}

\item{W}{A weight matrix across all observations, i.e inverse of a pairwise distance matrix.}

\item{gstar}{Whether to calculate the Gi* statistics, default is \code{TRUE}.}

\item{alternative}{Alternative hypothesis used, default is \code{two.sided}.}

\item{p.adjust.method}{Method used for multiple comparisons correction, default is \code{BH}. See \code{\link[stats]{p.adjust}}.}
}
\value{
A list containing the following:
\itemize{
\item Gi, Gi or Gi* statistics.
\item p.val, permutation based p-value.
\item p.adj, adjusted p-values.
\item gstar, permutation used if returned.
\item alternative, alternative hypothesis used.
\item p.adjust.method, method used for multiple comparisons correction.
}
}
\description{
Calculate local Getis-Ord Gi or Gi* statistics.
}
\examples{
{
data.use <- quakes[1:100,]
W <- 1/as.matrix(dist(data.use[,1:2]))
diag(W) <- 0
res <- LocalGi(data.use[,3:4], W)
}
}
\references{
Getis, A. & Ord, J. K. The analysis of spatial association by use of distance statistics. Geogr. Anal. 24, 189–206 (1992)
}
\concept{local}
