% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markedIPPP_mix.R
\name{est_MIPPP_cond_mark}
\alias{est_MIPPP_cond_mark}
\title{Fit a MIPPP conditionally on mark}
\usage{
est_MIPPP_cond_mark(pp, m = 10, L = 50000, burnin = floor(L/10), hyper_da,
  hyper, fit_markdist = TRUE, truncate = FALSE, grayscale = FALSE,
  discrete_mark = TRUE, LL = 256, open_new_window = FALSE,
  show_plots = TRUE, compute_surfaces = TRUE)
}
\arguments{
\item{pp}{Marked point pattern of class \code{\link[spatstat]{ppp}}.}

\item{m}{A vector representing the number
of components to fit for the ground
process corresponding to each mark. Since in
real applications we don't know these numbers
we can specify an integer so that
the routine will fit a BDMCMC
with this \code{m} as the maximum
number of components. Then we use
the MAP number of components for
each ground process with a mixture intensity function
of this many components. If not supplied
the default is \code{m=10}.}

\item{L}{Number of iterations for the MCMC; default is 50000.}

\item{burnin}{Number of initial realizations to discard. By default, it is 1/10 of the total number of iterations.}

\item{hyper_da}{A list of hyperparameters for
\code{\link{est_mix_damcmc}}. Each element of
this list should contain 3 values (hyperparameters) and
the number of elements should be the same as the
number of marks. If this parameter is omitted
the default hyperparameters of \code{\link{est_mix_damcmc}} will be used.}

\item{hyper}{Hyperparameter for the mark distribution. Must be a vector of positive real numbers. If omitted the vector of one's is used.}

\item{fit_markdist}{Logical variable requesting to fit and return the parameter estimates of the mark distribution.}

\item{truncate}{Logical variable indicating whether or not we
we only work with events within the window defined
in the point pattern \code{pp}.}

\item{grayscale}{Logical to request plots in grayscale.}

\item{discrete_mark}{Logical flag indicating whether the mark is discrete or not.
For continuous marks set this to FALSE.}

\item{LL}{Length of the side of the square grid.}

\item{open_new_window}{Open a new window for a plot.}

\item{show_plots}{Logical variable requesting to produce the ground fits and probability field plots for each mark. If label switching is present, the MAPE surface is computed and returned, otherwise the PME.}

\item{compute_surfaces}{Logical to request computation of the Average of Surfaces (if \code{m} is a vector) or the Bayesian Model Average (if \code{m} is an integer or missing). Default is TRUE. This is a SLOW operation.}
}
\value{
An object of class \code{MIPPP_fit}, which is simply a list containing the following components:
\item{gen_mark_ps}{The posterior realizations of the discrete mark distribution probabilities.}
\item{mark_dist}{The posterior means of the discrete mark distribution probabilities.}
\item{discrete_mark}{Same logical flag as the input argument.}
\item{pp}{Same as the input argument.}
\item{ground_fits}{A List of objects of type \code{damcmc_res} which contain the results of the DAMCMC (or the BDMCMC for MAP number of components) fits to the ground process for each discrete mark value.}
\item{ground_fitsAoS}{A List of objects of type \code{\link[spatstat]{im}} which contain the AoS (average of surfaces) surface based on the DAMCMC (or the BMA from BDMCMC) fits to the ground process for each discrete mark value.}
\item{post_surf}{A List of \code{intensity_surface} objects, one for each mark, representing the surface of posterior means, after fixing label switching using SEL permutation.}
\item{condition_on_loc}{Logical variable indicating the type of conditioning used in order to produce this MIPPP fit. For this function it is set to FALSE.}
\item{fit_DAMCMC}{Logical variable indicating whether or not a DAMCMC or BDMCMC fit was requested.}
\item{m}{Same as input.}
}
\description{
This function fits a Marked IPPP (MIPPP) on a marked
point pattern by modeling the (joint)
intensity surface of the locations and the marks
using an IPPP for the marks (independent
of the locations) and an IPPP with mixture intensity
for the corresponding ground process, where the
mixture parameters depend on the mark value.
NOTE: The estimation procedure for continuous
marks will be implemented
in future versions of the \code{sppmix} package.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#est_MIPPP_cond_mark}
}
\examples{
\donttest{
#Create a marked point pattern; use randomization and 3 discrete marks
newMPP=rMIPPP_cond_mark( params=c(.2,.5,.3),bigwin = spatstat::owin(c(-10,10),c(-10,10)))
newMPP$params
#supply the true number of components for each ground process
m=c(newMPP$groundsurfs[[1]]$m, newMPP$groundsurfs[[2]]$m, newMPP$groundsurfs[[3]]$m)
MIPPPfit=est_MIPPP_cond_mark(newMPP$genMPP,m=m,compute_surfaces=FALSE)
#check out the mark distribution parameters
#posterior means
MIPPPfit$mark_dist
#credible sets
GetStats(MIPPPfit$gen_mark_ps[,1])$CredibleSet#should contain .2
GetStats(MIPPPfit$gen_mark_ps[,2])$CredibleSet#should contain .5
GetStats(MIPPPfit$gen_mark_ps[,3])$CredibleSet#should contain .3
#now pretend we do not know the truth as is usually the case. Supply an integer
#for m so that the routine will fit a BDMCMC with this as the max number of
#components and use the MAP number of components
MIPPPfit=est_MIPPP_cond_mark(newMPP$genMPP,m=7,compute_surfaces=FALSE)
#check out the mark distribution parameters
MIPPPfit$mark_dist
GetStats(MIPPPfit$gen_mark_ps[,1])$CredibleSet#should contain .2
GetStats(MIPPPfit$gen_mark_ps[,2])$CredibleSet#should contain .5
GetStats(MIPPPfit$gen_mark_ps[,3])$CredibleSet#should contain .3}

}
\seealso{
\code{\link{rMIPPP_cond_mark}},
\code{\link{GetStats}}
}
\author{
Sakis Micheas, Jiaxun Chen
}
