% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mvn.R
\name{fit_mvn}
\alias{fit_mvn}
\title{Multivariate normal mixture model clustering}
\usage{
fit_mvn(Y, K, nsim = 2000, burn = 1000, z_init = NULL)
}
\arguments{
\item{Y}{An n x g matrix of gene expression values. n is the number of cell spots and g is the number of features.}

\item{K}{The number of mixture components to fit.}

\item{nsim}{Number of total MCMC iterations to run.}

\item{burn}{Number of MCMC iterations to discard as burn in. The number of saved samples is nsim - burn.}

\item{z_init}{Optional initialized allocation vector. Randomly initialized if NULL.}
}
\value{
a list of posterior samples
}
\description{
Implement Gibbs sampling for MVN model with no spatial random effects
}
\examples{
\donttest{
n <- 100 # number of observations
g <- 3 # number of features
K <- 3 # number of clusters (mixture components)
pi <- rep(1/K,K) # cluster membership probability
z <- sample(1:K, size = n, replace = TRUE, prob = pi) # cluster indicators
z <- remap_canonical2(z)

# Cluster Specific Parameters
# cluster specific means
Mu <- list(
  Mu1 = rnorm(g,-5,1),
  Mu2 = rnorm(g,0,1),
  Mu3 = rnorm(g,5,1)
)
# cluster specific variance-covariance
S <- matrix(1,nrow = g,ncol = g) # covariance matrix
diag(S) <- 1.5
Sig <- list(
  Sig1 = S,
  Sig2 = S, 
  Sig3 = S
)

Y <- matrix(0, nrow = n, ncol = g)
for(i in 1:n)
{
  Y[i,] <- mvtnorm::rmvnorm(1,mean = Mu[[z[i]]],sigma = Sig[[z[i]]])
}

# fit model
fit1 <- fit_mvn(Y,3,10,0)}
}
