% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUIcollections.R
\name{heightMatcher}
\alias{heightMatcher}
\title{Match height of one element to the other element}
\usage{
heightMatcher(div1, div2, isID = TRUE)
}
\arguments{
\item{div1}{element ID, or jquery selector if \code{isID = FALSE}. The first element
that you want to match the height to the other element}

\item{div2}{matched element ID or selector, the other element}

\item{isID}{bool, if \code{TRUE}, \code{div1} and \code{div2} will be treated as ID, otherwise
you can use complex jquery selector}
}
\value{
will be run as javascript
}
\description{
Match the height of one element to the second element.
If the height of second element change, the height of first element will change
automatically
}
\examples{
if(interactive()){
    library(shiny)
    library(shinyjqui)
    ui <- fluidPage(
        column(
            3, id = "a",
            style = "border: 1px black solid; background-color: gray;",
            p("This block's height is matched with orange one")
        ),
        shinyjqui::jqui_resizable(column(
            2, id ="b",
            style = "border: 1px black solid; background-color: orange;",
            p("drag the bottom-right corner")
        )),
        column(
            3, id = "c",
            style = "border: 1px black solid; background-color: red;",
            p("This block's is not matched with others")
        ),
        heightMatcher("a", "b")
    )

    server <- function(input, output, session) {

    }
    # Try to drag `b` from bottom right corner and see what happens to `a`
    shinyApp(ui, server)
}
}
