% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptf.cW.R
\name{ptf.cW}
\alias{ptf.cW}
\title{Title Corrected Weynants et al. (2009) Pedotransfer Function}
\usage{
ptf.cW(CLAY, SAND, BD, OC)
}
\arguments{
\item{CLAY}{A vector of \code{n} elements with soil clay content (particle diameters <= 2 x 10e-6 m), in percent [0, 100]).}

\item{SAND}{A vector of \code{n} elements with soil sand content (particle diameters < 2 mm and > 50 x 10e-6 m), in percent [0, 100]).}

\item{BD}{A vector of \code{n} elements with soil bulk density (g/cm3).}

\item{OC}{A vector of \code{n} elements with soil organic carbon content, in percent [0, 100].}
}
\value{
Pedotransfer function returns the van Genuchten - Mualem model parameters given \code{CLAY}, \code{SAND}, \code{BD}, and \code{OC}.
The correction of the original paper presented by \insertCite{Weynants.2009}{spsh}, were made by \insertCite{Weihermuller.2017}{spsh}, which is implemented.
}
\description{
Title Corrected Weynants et al. (2009) Pedotransfer Function
}
\note{
The PTF is not suitable for predicting the hydraulic conductivity curve at pressured heads > -6 cm \insertCite{Weynants.2009}{spsh}.
}
\examples{
result <- ptf.cW(CLAY = .4, SAND = .4, BD = 1.6, OC = .5)

}
\references{
\insertRef{Weynants.2009}{spsh}
\insertRef{Weihermuller.2017}{spsh}
}
\author{
Melanie Weynants, \email{mweynants@gmail.com}

Tobias KD Weber , \email{tobias.weber@uni-hohenheim.de}
}
