% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shypFun.03110.R
\name{shypFun.03110}
\alias{shypFun.03110}
\title{Unimodal Fredlund-Xing - Mualem Model}
\usage{
shypFun.03110(p, h)
}
\arguments{
\item{p}{vector of the 6 van Genuchten-Mualem model parameters, order is sensitve and has to be given as:
\tabular{lll}{
      \code{thr}\tab{residual water water content [cm cm-3]}\cr
      \code{ths}\tab{saturated water water content [cm cm-3]}\cr
      \code{alf1}\tab{inverse of the air entry pressure head [cm]}\cr
      \code{n1}\tab{width of pore size distribution [ - ]}\cr
      \code{Ks}\tab{saturated conductivity [cm d-1]}\cr
      \code{tau}\tab{exponent of \code{Se} in the capillary conductivity model, sometimes denoted in the literature as \code{l} [ - ]}\cr
}}

\item{h}{pressure heads [cm] for which the corresponding retention and conductivity values are calculated.}
}
\value{
returns a \code{list} with calculations at specified \code{h}:
\item{theta}{calculated volumetric moisture content}
\item{Se}{calculated saturation}
\item{cap}{specific water capacity function}
\item{psd}{pore size distribution}
\item{Kh}{Hydraulic conductivity values}
}
\description{
Calculates the soil hydraulic property function values based on given pressure heads. The function calculates the base function of Fredlund and Xing \insertCite{Fredlund.1994}{spsh}.
}
\details{
The function numerically solves the spec. water capacity function and integral to Mualem's conductivity model.
}
\examples{
p      <- c(0.1, 0.4, 0.01, 2, 100, .5)
h      <- 10^seq(-2, 6.8, length = 197)
shyp.L <- shypFun.03110(p, h)
}
\references{
\insertRef{Fredlund.1994}{spsh}
}
\author{
Tobias KD Weber , \email{tobias.weber@uni-hohenheim.de}
}
