%     The spsmooth R package
%     An extension for mgcv.
%     Copyright (C) 2012 Wesley Burr
%
%     Written by Wesley Burr.
%
%     This help file inspired by summary.gam.Rd from the mgcv package 
%     written by Simon N. Wood. 
%
%     This file is part of the spsmooth package for R.
%
%     The spsmooth package is free software: you can redistribute it and
%     or modify it under the terms of the GNU General Public License as 
%     published by the Free Software Foundation, either version 2 of the 
%     License, or any later version.
%
%     The spsmooth package is distributed in the hope that it will be 
%     useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
%     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License for more details.
%
%     You should have received a copy of the GNU General Public License
%     along with spsmooth.  If not, see <http://www.gnu.org/licenses/>.
%
%     If you wish to report bugs please contact the author. 
%     Wesley Burr
%     wburr@mast.queensu.ca
%     239 Jeffery Hall, Queen's University, Kingston, Ontario
%     Canada, K7L 3N6

\name{summary.gam}
\alias{summary.gam}
\title{Summary for a GAM fit (wrapper)}
\description{ 
    Takes a fitted \code{gam} object produced by \code{gam()} and produces various useful
    summaries from it. (See \code{sink} to divert output to a file.)
}
\usage{
  \method{summary}{gam}(object, ...)
}
\arguments{
  \item{object}{
      A \code{\link[mgcv]{gam}} object, usually generated by a call 
      \code{gam(Formula, data, ...)}. Will contain a list element
      \code{smooth}, which is itself a list of all of the smooth elements
      in the \code{Formula} passed. 
}
  \item{...}{
     For a full list of possible parameters, see \code{\link[mgcv]{summary.gam}}
     in \code{mgcv}.
  }
}
\details{
    This function overloads \code{summary.gam} from \code{\link[mgcv]{gam}} in
    mgcv. It does a check on the \code{class} attribute of each smoother
    contained in \code{object[["smooth"]]}, and if one or more of these
    smooth objects is of class \code{sp.smooth}, it sets two parameters:
    \code{freq=TRUE} and \code{p.type=5}. It then passes the object and 
    all additional parameters to \code{\link[mgcv]{summary.gam}} in
    the \code{\link{mgcv}} namespace. 

    If there are no smooth objects of class \code{sp.smooth}, this function
    simply falls through to the \code{\link[mgcv]{summary.gam}} function
    in the \code{\link{mgcv}} namespace.
}
\value{ An object of class \code{summary.gam}. For full details, see
    \code{\link[mgcv]{summary.gam}}. 
}
\references{
   Wood S.N. (2006) Generalized Additive Models: An Introduction with R. Chapman
   and Hall/CRC Press.
}
\author{
    Wesley Burr
}
\keyword{ smooth }
\keyword{ model }
