%     The spsmooth R package
%     An extension for mgcv.
%     Copyright (C) 2012 Wesley Burr
%
%     Written by Wesley Burr.
%
%     This help file inspired by smooth.construct.cr.smooth.spec.Rd from 
%     the mgcv package written by Simon N. Wood. 
%
%     This file is part of the spsmooth package for R.
%
%     The spsmooth package is free software: you can redistribute it and
%     or modify it under the terms of the GNU General Public License as 
%     published by the Free Software Foundation, either version 2 of the 
%     License, or any later version.
%
%     The spsmooth package is distributed in the hope that it will be 
%     useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
%     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License for more details.
%
%     You should have received a copy of the GNU General Public License
%     along with spsmooth.  If not, see <http://www.gnu.org/licenses/>.
%
%     If you wish to report bugs please contact the author. 
%     Wesley Burr
%     wburr@mast.queensu.ca
%     239 Jeffery Hall, Queen's University, Kingston, Ontario
%     Canada, K7L 3N6

\name{smooth.construct.sp.smooth.spec}
\alias{smooth.construct.sp.smooth.spec}
\title{Slepian projection smoothers in GAMs}
\description{
    \code{\link[mgcv]{gam}} can use arbitrary smooths, specified
    via terms like \code{s(x, bs="XX")}. This extension package
    allows for use of the term \code{s(x, bs="sp")} which specifies
    a non-penalized Slepian (discrete prolate spheroidal sequence)
    projection smoother. 
}
\usage{
\method{smooth.construct}{sp.smooth.spec}(object, data, knots) 
}
\arguments{
  \item{object}{
      A smooth specification object, usually generated by a term
      \code{s(..., bs="sp", xt=c(W=w, mask=UserMask), ...)}, where
      the user-specified \code{W} is the standardized bandwidth and 
      \code{UserMask} is a logical vector corresponding
      to data availability for the GAM.
}
  \item{data}{
      A list containing just the data required by this term, typically
      an index series corresponding to time. Name should correspond to
      \code{object$term}.

      If data does not consist of a contiguous index series (in time), 
      element \code{mask} must be included as part of object. This is done
      by including \code{xt=c(mask=UserMask)} as a parameter to the \code{s}
      function call. See the example in \code{\link{spsmooth}}.
}
  \item{knots}{
      Object should be NULL, and is functionally ignored. Only included
      for compatibility with \code{\link[mgcv]{gam}} framework.
}
}
\details{
    The constructor is not normally called directly, but is rather used
    internally by \code{\link[mgcv]{gam}}.

    As a subspace projection operator, this smoother does not use knots: 
    each basis vector has full support.

    Suggests that a bandwidth parameter be set, \code{0 < W < 0.5}. This
    bandwidth parameter is directly equivalent to the band-pass
    of the resulting projection operator. This parameter is standardized
    to be in units of \code{cycles/timeStep}, where \code{timeStep} is the
    dT time step for the data being smoothed, i.e. 1 hour, 1 day, etc..

    In the case of missing data, requires a mask vector be passed
    as an extra parameter via the \code{s(..., xt=c(mask=UserMask))} in 
    \code{\link[mgcv]{gam}} in order to accurately compute the 
    basis matrix.
}
\value{ An object of class \code{sp.smooth}. In addition to the usual 
    elements of a smooth class documented under
    \code{\link[mgcv]{smooth.construct}}, this object will contain: 
    \item{v}{Full-length basis matrix, before sub-selecting for missing
        data.}
    \item{N}{Length of full (including NA) index series.}
    \item{k}{Number of basis vectors used, typically \code{floor(2NW) - 1}.}
    \item{W}{Time-Bandwidth parameter, strictly bounded 0 < W < 0.5.}
    \item{C}{Defaulted to 1, removing centering constraints. These constraints
        tamper with the innate orthonormality of the basis vectors.}
}
\references{
    Slepian, D. (1978) Prolate Spheroidal Wave Functions, Fourier Analysis
    and Uncertainty -- V: The Discrete Cases. Bell Systems Technical 
    Journal, V. 57, pp. 1371-1429.
}
\author{
    Wesley Burr
}
\keyword{ smooth }
\keyword{ model }
