% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.format.R
\name{input.format}
\alias{input.format}
\title{Format an Input Value}
\usage{
input.format(x, n.digits = 2, miss = "NA")
}
\arguments{
\item{x}{The input value.}

\item{n.digits}{The number of digits after the decimal point, which can be
zero. The default is 2.}

\item{miss}{The missing value code expressed as a character string.  The
default is "NA".}
}
\value{
A value of mode character that is one of the following, as
  appropriate: (1) character representation of a real number with the
  specified number of digits after the decimal point when the input numeric
  value is a real number, (2) character representation of an integer when the
  input numeric value is an integer, (3) the original value when the input
  value is class character or factor, or (4) the missing value code when the
  input value is missing.
}
\description{
This function formats an input value of class numeric, character, or factor.
For a numeric value, the number of digits after the decimal point can be
specified.  A factor value is converted to character.  Missing values are
allowed.
}
\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
