% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_player_rankings_history.R,
%   R/get_player_recent_.R
\name{get_player_profile_urls}
\alias{get_player_profile_urls}
\title{Get a player's PSA ranking history from SquashInfo}
\usage{
get_player_profile_urls(
  player = NULL,
  rank = NULL,
  category = c("mens", "womens")
)

get_player_profile_urls(
  player = NULL,
  rank = NULL,
  category = c("mens", "womens")
)
}
\arguments{
\item{player}{character string of player name.}

\item{rank}{single integer or vector of integers indicating the rank of the PSA player(s) to return.}

\item{category}{character string indicating the competition category. Must be one of "both", "mens", or "womens".}
}
\value{
Tibble containing the year, month, exact date, rank, player name and player's current rank.

Data frame containing player ranks, names, and profile slugs.
}
\description{
Given a player name or rank, and a competition category, \code{get_player_rankings_history()} returns a tidy version of the PSA rankings history table for that player(s).

Given the player name, rank(s), and competition category, \code{get_player_profile_urls()} returns profile slugs of ranked players in PSA World Tour competitions.
}
