% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_retro.r
\name{change_retro}
\alias{change_retro}
\title{Alter a starter file for a retrospective analysis}
\usage{
change_retro(str_file_in = "starter.ss", str_file_out = "starter.ss",
  retro_yr = 0)
}
\arguments{
\item{str_file_in}{A string providing the path to the input SS3 \code{starter.ss} file.}

\item{str_file_out}{A string providing the path to the output SS3 \code{starter.ss} file.}

\item{retro_yr}{*Which retrospective year to enter into the starter file.
Should be 0 (no retrospective analysis) or a negative value.}
}
\value{
A modified SS3 starter file.
}
\description{
A retrospective analysis tests the effect of peeling back the number of
operating model years observable to the estimation model. This function
alters the SS3 starter file to run a retrospective analysis.
If used with \code{\link{run_ss3sim}} the case file should be named
\code{R}. A suggested (default) case letter is \code{R}.
}
\details{
Note that the starter file is set up to run a single retrospective
  run. Therefore, if you would like to run retrospective analyses for, say,
  0, 1, 2, 3, 4, and 5 years, you will need to use this function to adjust
  the starter file 6 separate times.
}
\section{Which arguments to specifiy in case files}{

All function argument descriptions that start with an asterisk (*) will be passed
through the case files to \code{\link{run_ss3sim}}. If one of these arguments
is not specified in a case file, then a value of \code{NULL} will be passed,
which may or may not be an appropriate value. Other arguments will be ignored
if specified.
}

\examples{
# Create a temporary folder for the output:
temp_path <- file.path(tempdir(), "ss3sim-retro-example")
dir.create(temp_path, showWarnings = FALSE)

# Locate the package data:
starterfile <- system.file("extdata", "models", "cod-om",
 "starter.ss", package = "ss3sim")

# No retrospective analysis:
change_retro(starterfile, paste0(temp_path, "/retro-0-starter.ss"),
retro_yr = 0)

# A retrospective analysis of 5 years:
change_retro(starterfile, paste0(temp_path, "/retro-5-starter.ss"),
retro_yr = -5)
}
\seealso{
Other change functions: \code{\link{change_data}},
  \code{\link{change_em_binning}}, \code{\link{change_e}},
  \code{\link{change_f}}, \code{\link{change_maturity}},
  \code{\link{change_tv}}
}
\author{
Sean C. Anderson
}
