% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldd.R
\name{ldd}
\alias{ldd}
\title{Latent dependency detection}
\usage{
ldd(T1, T2, m1 = 1000, m2 = 1000, perm = 0, p1 = TRUE, p2 = TRUE,
  jitter = NULL)
}
\arguments{
\item{T1, T2}{paired vectors of test statistics, both must be the same length; can be p-values or otherwise; if not p-values, must be stochastically larger under the null}

\item{m1, m2}{search only up the m1th (m2th) most significant test statistic in T1 (T2); NULL to search through all statistics}

\item{perm}{the indices of T1 will be randomly permuted \code{perm} times}

\item{p1, p2}{TRUE if T1 (T2) is a vector of p-values}

\item{jitter}{NULL if no jittering is desired to resolve ties, otherwise a jitter of \code{runif(0,jitter)} will be added to all entries of T1 and T2}
}
\value{
\item{D}{value of the test statistic}
\item{p.perm}{permutation p-value}
\item{p.asymp}{asymptotic approximate p-value}
}
\description{
Given two sequences of paired test statistics, tests whether the latent indicators of significance are positively dependent.
}
\examples{
## generate paired test statistics
\donttest{
p <- 10^6; ## total number of pairs
X <- c(rep(0,p-30),rep(1,10),rep(2,10),rep(3,10));
## X=0: no signal in either sequence of tests
## X=1: signal in sequence 1 only
## X=2: signal in sequence 2 only
## X=3: simultaneous signal
set.seed(1);
Z1 <- rnorm(p,0,1); Z1[X==1|X==3] <- rnorm(20,3,1);
Z2 <- rnorm(p,0,1); Z2[X==2|X==3] <- rnorm(20,4,1);
## convert to p-value
P1 <- 2*pnorm(-abs(Z1));
P2 <- 2*pnorm(-abs(Z2));
## run different version of ldd()
out.pp <- ldd(P1,P2,perm=100);
out.zp <- ldd(abs(Z1),P2,p1=FALSE,perm=100);
out.pz <- ldd(P1,abs(Z2),p2=FALSE,perm=100);
out.zz <- ldd(abs(Z1),abs(Z2),p1=FALSE,p2=FALSE,perm=100);
}

}

