% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssd-plot.R
\name{ssd_plot}
\alias{ssd_plot}
\title{SSD Plot}
\usage{
ssd_plot(
  data,
  pred,
  left = "Conc",
  right = left,
  label = NULL,
  shape = NULL,
  color = NULL,
  size = 2.5,
  xlab = "Concentration",
  ylab = "Percent of Species Affected",
  ci = TRUE,
  ribbon = FALSE,
  hc = 5L,
  shift_x = 3
)
}
\arguments{
\item{data}{A data frame.}

\item{pred}{A data frame of the predictions.}

\item{left}{A string of the column in data with the concentrations.}

\item{right}{A string of the column in data with the right concentration values.}

\item{label}{A string of the column in data with the labels.}

\item{shape}{A string of the column in data for the shape aesthetic.}

\item{color}{A string of the column in data for the color aesthetic.}

\item{size}{A number for the size of the labels.}

\item{xlab}{A string of the x-axis label.}

\item{ylab}{A string of the x-axis label.}

\item{ci}{A flag specifying whether to estimate confidence intervals (by parametric bootstrapping).}

\item{ribbon}{A flag indicating whether to plot the confidence interval as a grey ribbon as opposed to green solid lines.}

\item{hc}{A count between 1 and 99 indicating the percent hazard concentration (or NULL).}

\item{shift_x}{The value to multiply the label x values by.}
}
\description{
SSD Plot
}
\examples{
ssd_plot(boron_data, boron_pred, label = "Species", shape = "Group")
}
