% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sship.R
\name{ship}
\alias{ship}
\alias{sship}
\alias{dispatch}
\alias{dispatchable}
\alias{make_url}
\alias{make_opts}
\title{Secure cargo and make shipment (secure shipment)}
\usage{
sship(content, recipient, pubkey_holder, vessel, declaration = "")

dispatch(recipient, vessel, cargo)

dispatchable(recipient, vessel)

make_url(recipient, vessel)

make_opts(recipient, vessel)
}
\arguments{
\item{content}{Character string: the full path to the file to be shipped}

\item{recipient}{Character string: user name uniquely defining the recipient
both in terms of the public key used for securing the content and any
identity control upon docking. See also \emph{Details}.}

\item{pubkey_holder}{Character string: the holder of the (recipient's)
public key. Currently, the only viable option here is 'github'.}

\item{vessel}{Character string: means of transportation. Currently one of
'ssh' or 'ftp'.}

\item{declaration}{Character string: the name of an empty file to be
associated with shipment of the cargo itself and dispatched immediately
after. The most likely usecase is for the recipient to check for this file
being present before picking up the cargo itself. Default value is \code{""}
in which case no declaration will be used.}

\item{cargo}{Character vector: all items associated with the current
shipment. Used only internally.}
}
\value{
TRUE if successful
}
\description{
First, the content (a file) is encrypted and packed and then shipped to the
recipient using the specified vessel (transportation method). If the given
vessel is not available the function return an error. Optionally, a
declaration can also be associated with the shipment and dispatched
immediately after the actual cargo.
}
\details{
Most likely access control will be enforced before docking of the shipment
can commence. For each recipient a list of available vessels (transport
methods) is defined and must include relevant credentials. Functions used
here rely on local configuration (\code{sship.yml}) to access such
credentials.
}
\seealso{
\link{enc}
}
