% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dec.R
\name{dec}
\alias{dec}
\title{Unpack shipment and decrypt content}
\usage{
dec(tarfile, keyfile = "~/.ssh/id_rsa", target_dir = ".")
}
\arguments{
\item{tarfile}{Character string providing full path to the gzip-compressed
tarball holding the shipment payload, including encrypted files.}

\item{keyfile}{Character string providing the full path to the private RSA
key to be used for decryption of the encrypted key that is part of the
shipment. Default value is set to \code{~/.ssh/id_rsa} which is the usual
path for unix type operating systems.}

\item{target_dir}{Character string providing the full path to where the
decrypted file is to be written. Defaults to the current directory
\code{"."}, \emph{e.g.} where this function is being called from.}
}
\value{
Invisibly a character string providing the file path of the
  decrypted file.
}
\description{
This function tries to reverse the process of \link{enc} and hence depend on
the conventions used there.
}
\details{
Some of the functions used here might be vulnerable to differences between
systems running R. Possible caveats may be the availability of the
(un)tar-function and how binary streams/files are treated.
}
\examples{
# Please note that these examples will write files to a local temporary
# directory.

## Make temporary workspace
wd <- tempdir()

## Make a private-public key pair named "id_rsa" and "id_rsa.pub"
keygen(directory = wd, type = "rsa", overwrite_existing = TRUE)

## Make a secured (encrypted) file
saveRDS(iris, file = file.path(wd, "secret.rds"), ascii = TRUE)
pubkey <- readLines(file.path(wd, "id_rsa.pub"))
secure_secret_file <-
  enc(filename = file.path(wd, "secret.rds"),
      pubkey_holder = NULL,
      pubkey = pubkey)

## Decrypt secured file using the private key
secret_file <-
  dec(tarfile = secure_secret_file,
      keyfile = file.path(wd, "id_rsa"),
      target_dir = wd)
}
\seealso{
\link{enc}
}
