% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.sspm}
\alias{predict,sspm_fit-method}
\alias{predict,sspm_dataset-method}
\title{Predict with a SPM model}
\usage{
\S4method{predict}{sspm_fit}(
  object,
  new_data = NULL,
  biomass = NULL,
  aggregate = FALSE,
  interval = FALSE,
  next_ts = FALSE,
  type = "response"
)

\S4method{predict}{sspm_dataset}(
  object,
  new_data = NULL,
  discrete = TRUE,
  type = "response",
  interval = FALSE
)
}
\arguments{
\item{object}{\strong{[sspm_fit]} Fit object to predict from.}

\item{new_data}{\strong{[data.frame]} New data to predict with.}

\item{biomass}{\strong{[character]} Biomass variable.}

\item{aggregate}{\strong{[logical]} For biomass predictions only, whether to
aggregate the data to the boundary level. Default to FALSE.}

\item{interval}{\strong{[logical]} Whether or not to calculate confidence, and
when possible, prediction intervals.}

\item{next_ts}{\strong{[logical]} For biomass, predict next timestep.}

\item{type}{ When this has the value \code{"link"} (default) the linear predictor (possibly with
associated standard errors) is returned. When \code{type="terms"} each component of the 
linear predictor is returned seperately (possibly with standard errors): this includes 
parametric model components, followed by each smooth component, but excludes
any offset and any intercept. \code{type="iterms"} is the same, except that any standard errors 
returned for smooth components will include the uncertainty about the intercept/overall mean.  When 
\code{type="response"} predictions 
on the scale of the response are returned (possibly with approximate
standard errors). When \code{type="lpmatrix"} then a matrix is returned
which yields the values of the linear predictor (minus any offset) when
postmultiplied by the
parameter vector (in this case \code{se.fit} is ignored). The latter
option is most useful for getting variance estimates for quantities derived from
the model: for example integrated quantities, or derivatives of smooths. A
linear predictor matrix can also be used to implement approximate prediction
outside \code{R} (see example code, below). }

\item{discrete}{\strong{[logical]} If \code{new_data} is NULL, whether to predict
based on a discrete prediction matrix (default to TRUE).}
}
\value{
A \code{dataframe} of predictions.
}
\description{
Predict using a fitted SPM model on the whole data or on new data
}
\examples{
\dontrun{
# Predictions for a model fit (usually, productivity)
predict(sspm_model_fit)
# To get biomass predictions, provide the variable name
predict(sspm_model_fit, biomass = "weight_per_km2_borealis")
# To get the next timestep predictions
predict(sspm_model_fit, biomass = "weight_per_km2_borealis", next_ts = TRUE)
}

}
