% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstsWrapper.R
\name{AutoSTR}
\alias{AutoSTR}
\title{Automatic STR decomposition for time series data}
\usage{
AutoSTR(
  data,
  robust = FALSE,
  gapCV = NULL,
  lambdas = NULL,
  reltol = 0.001,
  confidence = NULL,
  nsKnots = NULL,
  trace = FALSE
)
}
\arguments{
\item{data}{A time series of class \code{ts} or \code{msts}.}

\item{robust}{When \code{TRUE}, Robust STR decomposition is used. Default is \code{FALSE}.}

\item{gapCV}{An optional parameter defining the length of the sequence of
skipped values in the cross validation procedure.}

\item{lambdas}{An optional parameter.
A structure which replaces lambda parameters provided with predictors.
It is used as either a starting point for the optimisation of parameters or as the
exact model parameters.}

\item{reltol}{An optional parameter which is passed directly to \code{\link{optim}()}
when optimising the parameters of the model.}

\item{confidence}{A vector of percentiles giving the coverage of confidence intervals.
It must be greater than 0 and less than 1.
If \code{NULL}, no confidence intervals are produced.}

\item{nsKnots}{An optional vector parameter, defining the number of seasonal knots (per period) for each sesonal component.}

\item{trace}{When \code{TRUE}, tracing is turned on.}
}
\value{
A structure containing input and output data.
It is an \strong{S3} class \code{STR}, which is a list with the following components:
\itemize{
\item \strong{output} -- contains decomposed data. It is a list of three components:
\itemize{
\item \strong{predictors} -- a list of components where each component
corresponds to the input predictor. Every such component is a list containing the following:
\itemize{
\item \strong{data} -- fit/forecast for the corresponding predictor (trend, seasonal component, flexible or seasonal predictor).
\item \strong{beta} -- beta coefficients of the fit of the coresponding predictor.
\item \strong{lower} -- optional (if requested) matrix of lower bounds of confidence intervals.
\item \strong{upper} -- optional (if requested) matrix of upper bounds of confidence intervals.
}
\item \strong{random} -- a list with one component \strong{data}, which contains residuals of the model fit.
\item \strong{forecast} -- a list with two components:
\itemize{
\item \strong{data} -- fit/forecast for the model.
\item \strong{beta} -- beta coefficients of the fit.
\item \strong{lower} -- optional (if requested) matrix of lower bounds of confidence intervals.
\item \strong{upper} -- optional (if requested) matrix of upper bounds of confidence intervals.
}
}
\item \strong{input} -- input parameters and lambdas used for final calculations.
\itemize{
\item \strong{data} -- input data.
\item \strong{predictors} - input predictors.
\item \strong{lambdas} -- smoothing parameters used for final calculations (same as input lambdas for STR method).
}
\item \strong{cvMSE} -- optional cross validated (leave one out) Mean Squared Error.
\item \strong{optim.CV.MSE} -- best cross validated Mean Squared Error (n-fold) achieved during minimisation procedure.
\item \strong{nFold} -- the input \code{nFold} parameter.
\item \strong{gapCV} -- the input \code{gapCV} parameter.
\item \strong{method} -- always contains string \code{"AutoSTR"} for this function.
}
}
\description{
Automatically selects parameters for an STR decomposition of time series data.
The time series should be of class \code{ts} or \code{msts}.
}
\examples{
\donttest{

# Decomposition of a multiple seasonal time series
decomp <- AutoSTR(calls)
plot(decomp)

# Decomposition of a monthly time series
decomp <- AutoSTR(log(grocery))
plot(decomp)
}
}
\references{
Dokumentov, A., and Hyndman, R.J. (2016)
STR: A Seasonal-Trend Decomposition Procedure Based on Regression
\href{https://www.monash.edu/business/econometrics-and-business-statistics/research/publications/ebs/wp13-15.pdf}{www.monash.edu/business/econometrics-and-business-statistics/research/publications/ebs/wp13-15.pdf}
}
\seealso{
\code{\link{STR}}
}
\author{
Alexander Dokumentov
}
