% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_ical.R
\name{write_ical}
\alias{write_ical}
\title{Write ical object}
\usage{
write_ical(
  df,
  date = "date",
  date.end = NA,
  title = "title",
  time.start = "start",
  time.end = "end",
  place = NA,
  place.def = NA,
  time.def = "10:00:00",
  time.dur = 60,
  descr = NA,
  link = NA,
  t.zone = "CET"
)
}
\arguments{
\item{df}{A data frame with the calendar data}

\item{date}{The name of the event date column in the data frame}

\item{date.end}{The name of the end date column in the data frame}

\item{title}{The name of the title column in the data frame}

\item{time.start}{The name of the start time column in the data frame}

\item{time.end}{The name of the end time column in the data frame}

\item{place}{The name of the place column in the data frame}

\item{place.def}{Default location to use when place is NA}

\item{time.def}{Default start time to use when time.start is NA}

\item{time.dur}{Default duration of the event in minutes, if time.end is NA}

\item{descr}{Name of description/notes column if any.}

\item{link}{Name of link column, if any.}

\item{t.zone}{A character string of time zone for events. The string must be
a time zone that is recognized by the user's OS.}
}
\value{
ical object
}
\description{
This function creates an ical file based on a data frame with mixed events.
Export as .ics file using \code{calendar::ic_write()}.
}
\examples{
df <- data.frame(
  date = c("2020-02-10", "2020-02-11"),
  date.end = c("2020-02-13",NA),
  title = c("Conference", "Lunch"),
  start = c("12:00:00", NA),
  time.end = c("13:00:00", NA),
  note = c("Hi there","Remember to come"),
  link = c("https://icalendar.org","https://agdamsbo.github.io/stRoke/")
)

write_ical(
  df,
  date = "date",
  date.end = "date.end",
  title = "title",
  time.start = "start",
  time.end = "time.end",
  place.def = "Conference Room",
  descr = "note",
  link = "link"
)

}
\seealso{
\href{https://github.com/ATFutures/calendar/}{calendar package}
\href{https://icalendar.org}{icalendar standard webpage}
}
