% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_functions.R
\name{eem_ife_correction}
\alias{eem_ife_correction}
\title{Wrapper function to allow eem_inner_filter_effect (eemR) handling different cuvette lengths.}
\usage{
eem_ife_correction(data, abs_data, cuvl, unit = "absorbance")
}
\arguments{
\item{data}{fluorescence data of class eemlist}

\item{abs_data}{absorbance data}

\item{cuvl}{length of cuvette of absorption measurment in cm. Either a number or a data frame. Row names of data frame have to be similar to sample names in data}

\item{unit}{unit of absorbance data. Either "absorbance" or "absorption".}
}
\value{
fluorescence data of class eemlist
}
\description{
Calls \code{\link[eemR]{eem_inner_filter_effect}} for each sample to use different cuvette lengths.
}
\examples{
folder <- system.file("extdata/cary/scans_day_1", package = "eemR") # load example data
eem_list <- eem_read(folder, import_function = "cary")
data(absorbance)

eem_ife_correction(eem_list, absorbance, 5, unit = "absorbance")
}
