% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stab_masv.R
\name{stab_masv}
\alias{stab_masv}
\alias{stab_masv.default}
\title{Modified Additive Main Effects and Multiplicative Interacion Stability Value}
\usage{
stab_masv(.data, .y, .rep, .gen, .env, .m = 2)

\method{stab_masv}{default}(.data, .y, .rep, .gen, .env, .m = 2)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.rep}{Replication Factor}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}

\item{.m}{No of PCs retained}
}
\value{
Additive ANOVA
}
\description{
Additive ANOVA for Genotypes by Environment Interaction (GEI) model
}
\examples{
data(ge_data)
YieldMASV <-
     stab_masv(
            .data = ge_data
          , .y    = Yield
          , .rep  = Rep
          , .gen  = Gen
          , .env  = Env
          , .m    = 2
      )
YieldMASV

}
\references{
Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Kent M. Edkridge (\email{keskridge1@unl.edu})
         }
}
