% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stableSpec.R
\name{stableSpec}
\alias{stableSpec}
\title{Stable specifications of constrained structural equation models.}
\usage{
stableSpec(theData = NULL, nSubset = NULL, iteration = NULL,
  nPop = NULL, mutRate = NULL, crossRate = NULL, longitudinal = NULL,
  numTime = NULL, seed = NULL, co = NULL, consMatrix = NULL,
  threshold = NULL, toPlot = NULL)
}
\arguments{
\item{theData}{a data frame containing the data to which the model will be
be fit. If argument \code{longitudinal} is \code{TRUE}, the data frame
should be reshaped such that the first \code{n} data points contain the
relations that occur in the first two time slices \code{t_0} and \code{t_1}.
The next \code{n} data points contain the relations that occur in
time slices \code{t_1} and \code{t_2}. The \code{i-th} subset of \code{n}
data points contain the relations in time slices \code{t_i-1} and \code{t_i}.}

\item{nSubset}{number of subsets to draw. In practice, it is suggested
to have at least 25 subsets. The default is 10.}

\item{iteration}{number of iterations/generations for NSGA-II.}

\item{nPop}{population size (number of models) in a generation.
The default is 50.}

\item{mutRate}{mutation rate. The default is 0.075.}

\item{crossRate}{crossover rate. The default is 0.85.}

\item{longitudinal}{\code{TRUE} for longitudinal data,
and \code{FALSE} for cross-sectional data.}

\item{numTime}{number of time slices. If a cross-sectional data then
it is 1. The default is 1.}

\item{seed}{integer vector representing seeds that are used to subsample data.
The default is an integer vector with range \code{100:1000} with length
equal to \code{nSubset}.}

\item{co}{whether to use \code{"covariance"} or \code{"correlation"} matrix.
The default is \code{"covariance"}.}

\item{consMatrix}{\code{m by 2} binary \code{\link{matrix}}
representing constraint/prior knowledge,
where \code{m} is the number of constraint. For example, known that
variables 2 and 3 do not cause variable 1, then
\code{constraint <- matrix(c(2, 1, 3, 1), 2, 2, byrow=TRUE))} will be
the constraint matrix. If \code{NULL}, then it is assumed
that there is no constraint.}

\item{threshold}{threshold of stability selection. The default is 0.6.}

\item{toPlot}{if \code{TRUE} a plot of inferred causal model is generated,
otherwise a graph object is returned. The default is \code{TRUE}.}
}
\value{
a list of the following elements:
\itemize{
\item \code{listofFronts} is a \code{\link{list}} of optimal models for
the whole range of model complexity of all subsets.
\item \code{causalStab} is a \code{\link{list}} of causal path stability
for the whole range of model complexity
\item \code{causalStab_l1} is a \code{\link{list}} of
causal path stability of length 1
for the whole range of model complexity
\item \code{edgeStab} is a \code{\link{list}} of edge stability
for the whole range of mdoel complexity
\item \code{relCausalPath} is \code{n by n} \code{\link{matrix}} of
relevant causal path,
where \code{n} is the number of variables. Each positive element
\code{i,j} represents the stability of causal path
from \code{i} to \code{j}.
\item \code{relCausalPath_l1} is \code{n by n} \code{\link{matrix}}
of relevant causal path with length 1, where \code{n} is
the number of variables. Each positive element \code{i,j}
represents the stability of causal path
from \code{i} to \code{j} with length 1.
\item \code{relEdge} is \code{n by n} \code{\link{matrix}} of relevant edge,
where \code{n} is the number of variables. Each positive element
\code{i,j} represents the stability of edge
between \code{i} to \code{j}.
\item If argument \code{toPlot = TRUE}, then a plot of inferred causal model
is generated. Otherwise an object of graph is returned.
An arc represents a causal path, and an (undirected)
edge represents strong association where the direction is undecidable.
\item \code{allSeed} is an integer vector representing seeds that are used in
subsampling data. This can be used to replicate the result
in next computation.
}
}
\description{
Search stable specifications (structures) of constrained structural equation models.
}
\details{
This function performs exploratory search over
recursive (acyclic) SEM models.
Models are scored along two objectives: the model fit and
the model complexity. Since both objectives are often conflicting
we use NSGA-II to search for Pareto optimal models. To handle the
instability of small finite data samples, we repeatedly subsample
the data and select those substructures that are both stable and
parsimonious which are then used to infer a causal model.
}
\examples{
# Cross-sectional data example.
# with a data set about patients with ADHD.
# Detail about the data set can be found in the documentation.
# As an example, we only run one subset.
the_data <- adhd
numSubset <- 1
num_iteration <- 5
num_pop <- 10
mut_rate <- 0.075
cross_rate <- 0.85
longi <- FALSE
num_time <- 1
the_seed <- NULL
the_co <- "covariance"
# assummed that nothing causing variable Gender
cons_matrix <- matrix(c(2, 1, 3, 1, 4, 1, 5, 1, 6, 1), 5, 2, byrow=TRUE)
th <- 0.1
to_plot <- FALSE

result_adhd <- stableSpec(theData=the_data, nSubset=numSubset,
iteration=num_iteration,
nPop=num_pop, mutRate=mut_rate, crossRate=cross_rate,
longitudinal=longi, numTime=num_time, seed=the_seed,
co=the_co, consMatrix=cons_matrix, threshold=th, toPlot=to_plot)

}
\author{
Ridho Rahmadi \email{r.rahmadi@cs.ru.nl}, Perry Groot, Tom Heskes
}
\references{
Rahmadi, R., Groot, P., Heins, M., Knoop, H., & Heskes, T. (2015).
Causality on Cross-Sectional Data: Stable Specification Search in
Constrained Structural Equation Modeling. arXiv preprint arXiv:1506.05600.

John Fox, Zhenghua Nie and Jarrett Byrnes (2015). sem:
Structural Equation Models. R package version 3.1-6.
https://CRAN.R-project.org/package=sem

Ching-Shih Tsou (2013). nsga2R: Elitist Non-dominated Sorting
Genetic Algorithm based on R. R package version 1.0.
https://CRAN.R-project.org/package=nsga2R

Kalisch, M., Machler, M., Colombo, D., Maathuis, M. H., &
Buehlmann, P. (2012). Causal inference using graphical models
with the R package pcalg.
\emph{Journal of Statistical Software}, 47(11), 1-26.

Meinshausen, N., & Buehlmann, P. (2010). Stability selection.
\emph{Journal of the Royal Statistical Society:
Series B (Statistical Methodology)}, 72(4), 417-473.

Deb, K., Pratap, A., Agarwal, S., and Meyarivan, T. (2002),
A fast and elitist multiobjective genetic algorithm: NSGA-II,
\emph{IEEE Transactions on Evolutionary Computation}, 6(2), 182-197.

Chickering, D. M. (2002). Learning equivalence classes of
Bayesian-network structures. \emph{The Journal of
Machine Learning Research}, 2, 445-498.
}

