% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelPop.R
\name{modelPop}
\alias{modelPop}
\title{Random SEM models.}
\usage{
modelPop(nPop = NULL, numVar = NULL, longitudinal = NULL,
  consMatrix = NULL)
}
\arguments{
\item{nPop}{number of models to generate or population size.}

\item{numVar}{number of variables.}

\item{longitudinal}{\code{TRUE} for longitudinal data,
and \code{FALSE} for cross-sectional data.}

\item{consMatrix}{\code{m by 2} binary \code{\link{matrix}}
representing constraint/prior knowledge,
where \code{m} is the number of constraint. For example, known that
variables 2 and 3 do not cause variable 1, then
\code{constraint <- matrix(c(2, 1, 3, 1), 2, 2, byrow=TRUE))} will be
the constraint matrix.}
}
\value{
\code{nPop} or \code{minPop} by \code{m} \code{\link{matrix}},
where \code{m} is the length of the binary vector depending
of the given number of variables
and also whether longitudinal or cross-sectional model.
}
\description{
Generating recursive (acyclic) SEM models represented by
binary vectors.
}
\details{
This function generates \code{nPop} random SEM models which are
represented by binary vectors; 1 means there is a causal path from,
e.g., variable \code{A} to \code{B}
and 0 otherwise. In addition, the generated models
have passed the cyclic test to ensure they are all acyclic. The function
also includes \code{minPop} models which representing models
from each model complexity, i.e., \code{minPop = numVar(numVar-1)/2+1},
if \code{longitudinal = FALSE}, or
\code{minPop = (numVar(numVar-1)/2+1)+numVar^2}, otherwise.
If \code{nPop <= minPop} then
this function will generate \code{minPop} models.
}
\examples{
#assumming a prior knowledge that variable 1 does not cause variable 2
models <- modelPop(nPop=25, numVar=6,
longitudinal=FALSE, consMatrix = matrix(c(1, 2), 1, 2))
models
}
\author{
Ridho Rahmadi \email{r.rahmadi@cs.ru.nl}
}

