% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_year.R
\name{choice_c,ref_year-method}
\alias{choice_c,ref_year-method}
\title{choice_c method for ref_year referential from the command line}
\usage{
\S4method{choice_c}{ref_year}(
  object,
  annee,
  nomassign = "ref_year",
  funoutlabel = gettext("Year selected\\n", domain = "R-stacomiR"),
  silent = FALSE
)
}
\arguments{
\item{object}{An object of class \link{ref_year-class}}

\item{annee}{The year to select, either as a character or as a numeric}

\item{nomassign}{The name to be assigned in envir_stacomi}

\item{funoutlabel}{The label that appears in funout}

\item{silent}{Stops messages from being displayed if silent=TRUE, default FALSE}
}
\value{
object An object of class \link{ref_year-class} with year selected
}
\description{
The choice_c method will issue a warning if the year is not present in the database
Allows the selection of year and the assignment in environment envir_stacomi
}
\examples{
\dontrun{
object=new("ref_year")
object<-charge(object)
win=gwindow(title="test ref_year")
group=ggroup(container=win,horizontal=FALSE)
choice(object,nomassign="ref_year",funoutlabel="essai",titleFrame="essai ref_year",preselect=1)
dispose(win)
}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
